/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.io.Writer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonString;", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonNode;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "write", "", "writer", "Ljava/io/Writer;", "js.parser"})
public final class JsonString
extends JsonNode {
    @NotNull
    private final String value;

    public JsonString(@NotNull String value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        super(null);
        this.value = value2;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @Override
    public void write(@NotNull Writer writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        writer.append('\"');
        String string2 = this.value;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            char c2 = c;
            if (c2 == '\\') {
                writer.append("\\\\");
                continue;
            }
            if (c2 == '\"') {
                writer.append("\\\"");
                continue;
            }
            if (c2 == '\r') {
                writer.append("\\r");
                continue;
            }
            if (c2 == '\n') {
                writer.append("\\n");
                continue;
            }
            if (c2 == '\t') {
                writer.append("\\t");
                continue;
            }
            if (c2 == '\b') {
                writer.append("\\b");
                continue;
            }
            if (c2 == '\f') {
                writer.append("\\f");
                continue;
            }
            boolean bl = ' ' <= c2 ? c2 < '\u007f' : false;
            if (bl) {
                writer.append(c);
                continue;
            }
            writer.append("\\u");
            int shift = 0;
            shift = 16;
            int n2 = 4;
            for (int j = 0; j < n2; ++j) {
                int it = j;
                boolean bl2 = false;
                int digit = c >>> (shift -= 4) & 0xF;
                writer.append(digit < 10 ? (char)(digit + 48) : (char)(digit - 10 + 97));
            }
        }
        writer.append('\"');
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString();
    }

    @NotNull
    public final String component1() {
        return this.value;
    }

    @NotNull
    public final JsonString copy(@NotNull String value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        return new JsonString(value2);
    }

    public static /* synthetic */ JsonString copy$default(JsonString jsonString, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = jsonString.value;
        }
        return jsonString.copy(string2);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JsonString)) {
            return false;
        }
        JsonString jsonString = (JsonString)other;
        return Intrinsics.areEqual(this.value, jsonString.value);
    }
}

