/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ThreadLocalTypes;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodCallExpressionImpl
extends ExpressionPsiElement
implements PsiMethodCallExpression {
    private static final Logger LOG = Logger.getInstance(PsiMethodCallExpressionImpl.class);
    private static final TypeEvaluator ourTypeEvaluator = new TypeEvaluator();

    public PsiMethodCallExpressionImpl() {
        super(JavaElementType.METHOD_CALL_EXPRESSION);
    }

    @Override
    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, ourTypeEvaluator);
    }

    @Override
    public PsiMethod resolveMethod() {
        return (PsiMethod)this.getMethodExpression().resolve();
    }

    @Override
    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        JavaResolveResult javaResolveResult = this.getMethodExpression().advancedResolve(false);
        if (javaResolveResult == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(0);
        }
        return javaResolveResult;
    }

    @Override
    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(1);
        }
        if (child == this.getArgumentList()) {
            LOG.error("Cannot delete argument list since it will break contract on argument list notnullity");
        }
        super.removeChild(child);
    }

    @Override
    @NotNull
    public PsiReferenceParameterList getTypeArgumentList() {
        PsiReferenceExpression expression2 = this.getMethodExpression();
        PsiReferenceParameterList result2 = expression2.getParameterList();
        if (result2 != null) {
            PsiReferenceParameterList psiReferenceParameterList = result2;
            if (psiReferenceParameterList == null) {
                PsiMethodCallExpressionImpl.$$$reportNull$$$0(2);
            }
            return psiReferenceParameterList;
        }
        LOG.error("Invalid method call expression. Children:\n" + DebugUtil.psiTreeToString(expression2, false));
        PsiReferenceParameterList psiReferenceParameterList = result2;
        if (psiReferenceParameterList == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(3);
        }
        return psiReferenceParameterList;
    }

    @Override
    public PsiType @NotNull [] getTypeArguments() {
        PsiType[] psiTypeArray = this.getMethodExpression().getTypeParameters();
        if (psiTypeArray == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(4);
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    public PsiReferenceExpression getMethodExpression() {
        PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)this.findChildByRoleAsPsiElement(91);
        if (psiReferenceExpression == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(5);
        }
        return psiReferenceExpression;
    }

    @Override
    @NotNull
    public PsiExpressionList getArgumentList() {
        PsiExpressionList list2 = (PsiExpressionList)this.findChildByRoleAsPsiElement(73);
        if (list2 == null) {
            LOG.error("Invalid PSI for'" + this.getText() + ". Parent:" + DebugUtil.psiToString(this.getParent(), false));
        }
        PsiExpressionList psiExpressionList = list2;
        if (psiExpressionList == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(6);
        }
        return psiExpressionList;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 91: {
                return this.getFirstChildNode();
            }
            case 73: 
        }
        return this.findChildByType(JavaElementType.EXPRESSION_LIST);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.EXPRESSION_LIST) {
            return 73;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 91;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(8);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitMethodCallExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiMethodCallExpression:" + this.getText();
    }

    public static boolean doWePerformGenericMethodOverloadResolutionNow(PsiCall call2, LanguageLevel languageLevel) {
        PsiElement callParent = PsiUtil.skipParenthesizedExprUp(call2.getParent());
        PsiExpressionList parentArgList = languageLevel.isAtLeast(LanguageLevel.JDK_1_8) ? (callParent instanceof PsiConditionalExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)callParent) ? null : PsiTreeUtil.getParentOfType((PsiElement)call2, PsiExpressionList.class, true, PsiReferenceExpression.class)) : null;
        return parentArgList != null && MethodCandidateInfo.isOverloadCheck(parentArgList) && Arrays.stream(parentArgList.getExpressions()).map(expression2 -> PsiUtil.skipParenthesizedExprDown(expression2)).noneMatch(expression2 -> expression2 != null && ThreadLocalTypes.hasBindingFor(expression2));
    }

    private static PsiType captureReturnType(PsiMethodCallExpression call2, PsiMethod method, PsiType ret, JavaResolveResult result2, LanguageLevel languageLevel, PsiFile file2) {
        PsiType erased;
        PsiSubstitutor substitutor2 = result2.getSubstitutor();
        substitutor2.ensureValid();
        PsiType substitutedReturnType = substitutor2.substitute(ret);
        if (substitutedReturnType == null) {
            return TypeConversionUtil.erasure(ret);
        }
        if (result2 instanceof MethodCandidateInfo && ((MethodCandidateInfo)result2).isErased()) {
            return TypeConversionUtil.erasure(substitutedReturnType);
        }
        if (((!languageLevel.isAtLeast(LanguageLevel.JDK_1_8) || call2.getTypeArguments().length > 0) && method.hasTypeParameters() || !method.hasTypeParameters() && JavaVersionService.getInstance().isAtLeast(file2, JavaSdkVersion.JDK_1_8)) && !substitutedReturnType.equals(erased = TypeConversionUtil.erasure(substitutedReturnType)) && result2 instanceof MethodCandidateInfo && ((MethodCandidateInfo)result2).isApplicable()) {
            PsiType[] args = call2.getArgumentList().getExpressionTypes();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            boolean varargs = ((MethodCandidateInfo)result2).getApplicabilityLevel() == 2;
            for (int i = 0; i < args.length; ++i) {
                PsiType parameterType = substitutor2.substitute(PsiTypesUtil.getParameterType(parameters2, i, varargs));
                PsiType expressionType2 = args[i];
                if (expressionType2 == null || parameterType == null || !JavaGenericsUtil.isRawToGeneric(parameterType, expressionType2)) continue;
                return erased;
            }
        }
        if (PsiUtil.isRawSubstitutor(method, substitutor2)) {
            PsiType returnTypeErasure = TypeConversionUtil.erasure(ret);
            if (Comparing.equal(TypeConversionUtil.erasure(substitutedReturnType), returnTypeErasure)) {
                return returnTypeErasure;
            }
        }
        return PsiUtil.captureToplevelWildcards(substitutedReturnType, call2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMethodGenerics";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TypeEvaluator
    implements Function<PsiMethodCallExpression, PsiType> {
        private TypeEvaluator() {
        }

        @Override
        @Nullable
        public PsiType fun(PsiMethodCallExpression call2) {
            PsiReferenceExpression methodExpression = call2.getMethodExpression();
            PsiFile file2 = call2.getContainingFile();
            JavaResolveResult[] results = PsiImplUtil.multiResolveImpl(methodExpression, file2, false, PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE);
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(file2);
            boolean genericParentOverloadResolution = PsiMethodCallExpressionImpl.doWePerformGenericMethodOverloadResolutionNow(call2, languageLevel);
            PsiType theOnly = null;
            for (int i = 0; i < results.length; ++i) {
                PsiType type2;
                JavaResolveResult candidateInfo = results[i];
                PsiElement element = candidateInfo.getElement();
                if (genericParentOverloadResolution && element != null && PsiPolyExpressionUtil.isMethodCallPolyExpression((PsiExpression)call2, (PsiMethod)element)) {
                    LOG.error("poly expression evaluation during overload resolution, processing " + results.length + " results");
                }
                if ((type2 = TypeEvaluator.getResultType(call2, methodExpression, candidateInfo, languageLevel, file2)) == null) {
                    return null;
                }
                if (i == 0) {
                    theOnly = type2;
                    continue;
                }
                if (theOnly.equals(type2)) continue;
                return null;
            }
            return PsiClassImplUtil.correctType(theOnly, file2.getResolveScope());
        }

        @Nullable
        private static PsiType getResultType(@NotNull PsiMethodCallExpression call2, @NotNull PsiReferenceExpression methodExpression, @NotNull JavaResolveResult result2, @NotNull LanguageLevel languageLevel, @NotNull PsiFile file2) {
            PsiMethod method;
            if (call2 == null) {
                TypeEvaluator.$$$reportNull$$$0(0);
            }
            if (methodExpression == null) {
                TypeEvaluator.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                TypeEvaluator.$$$reportNull$$$0(2);
            }
            if (languageLevel == null) {
                TypeEvaluator.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                TypeEvaluator.$$$reportNull$$$0(4);
            }
            if ((method = (PsiMethod)result2.getElement()) == null) {
                return null;
            }
            PsiUtilCore.ensureValid(method);
            boolean is15OrHigher = languageLevel.compareTo(LanguageLevel.JDK_1_5) >= 0;
            PsiType getClassReturnType = PsiTypesUtil.patchMethodGetClassReturnType(call2, methodExpression, method, type2 -> type2 != JavaElementType.CLASS && type2 != JavaElementType.ANONYMOUS_CLASS, languageLevel);
            if (getClassReturnType != null) {
                return getClassReturnType;
            }
            PsiType ret = method.getReturnType();
            if (ret == null) {
                return null;
            }
            PsiUtil.ensureValidType(ret);
            if (ret instanceof PsiClassType) {
                ret = ((PsiClassType)ret).setLanguageLevel(languageLevel);
            }
            if (is15OrHigher) {
                return PsiMethodCallExpressionImpl.captureReturnType(call2, method, ret, result2, languageLevel, file2);
            }
            return TypeConversionUtil.erasure(ret);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "call";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "methodExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "languageLevel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl$TypeEvaluator";
            objectArray[2] = "getResultType";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

