/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.analysis.jvm.checkers.FirJvmHelperKt;
import org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration.FirJvmDefaultChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.java.JvmDefaultModeContainerKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.name.JvmNames;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J2\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012*\u0006\u0012\u0002\b\u00030\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmDefaultChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkNonJvmDefaultOverridesJavaDefault", "defaultAnnotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "jvmDefaultMode", "Lorg/jetbrains/kotlin/config/JvmDefaultMode;", "getOverriddenDeclarations", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmDefaultChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmDefaultChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmDefaultChecker\n+ 2 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt$findClosest$1\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n108#2,3:152\n113#2:156\n108#2,3:161\n113#2:165\n108#3:155\n108#3:164\n53#4:157\n53#4:159\n53#4:166\n34#5:158\n34#5:160\n34#5:167\n1747#6,3:168\n13#7:171\n1#8:172\n*S KotlinDebug\n*F\n+ 1 FirJvmDefaultChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmDefaultChecker\n*L\n39#1:152,3\n39#1:156\n118#1:161,3\n118#1:165\n39#1:155\n118#1:164\n42#1:157\n97#1:159\n119#1:166\n42#1:158\n97#1:160\n119#1:167\n124#1:168,3\n132#1:171\n*E\n"})
public final class FirJvmDefaultChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmDefaultChecker INSTANCE = new FirJvmDefaultChecker();

    private FirJvmDefaultChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirAnnotation defaultAnnotation;
        JvmDefaultMode jvmDefaultMode2;
        block22: {
            KtSourceElement source;
            block23: {
                FirAnnotation annotationWithCompatibility;
                FirSession session2;
                block19: {
                    KtSourceElement source2;
                    block21: {
                        block20: {
                            FirElement firElement;
                            block18: {
                                Intrinsics.checkNotNullParameter(declaration, "declaration");
                                Intrinsics.checkNotNullParameter(context, "context");
                                Intrinsics.checkNotNullParameter(reporter, "reporter");
                                jvmDefaultMode2 = JvmDefaultModeContainerKt.getJvmDefaultModeState(context.getSession());
                                session2 = context.getSession();
                                defaultAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JvmNames.INSTANCE.getJVM_DEFAULT_CLASS_ID(), session2);
                                if (defaultAnnotation == null) break block19;
                                CheckerContext $this$findClosest_u24default$iv = context;
                                boolean $i$f$findClosest = false;
                                for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                                    FirElement firElement2;
                                    FirDeclaration firDeclaration = it$iv;
                                    if (!(firDeclaration instanceof FirClassLikeDeclaration)) {
                                        firDeclaration = null;
                                    }
                                    if ((firElement = (FirElement)((FirClassLikeDeclaration)firDeclaration)) == null) continue;
                                    FirElement firElement3 = firElement2 = firElement;
                                    boolean bl = false;
                                    FirElement it = firElement3;
                                    firElement = true ? firElement2 : null;
                                    if (firElement == null) {
                                        continue;
                                    }
                                    break block18;
                                }
                                firElement = null;
                            }
                            FirClassLikeDeclaration containingDeclaration = (FirClassLikeDeclaration)firElement;
                            source2 = defaultAnnotation.getSource();
                            if (!(containingDeclaration instanceof FirClass)) break block20;
                            FirClass $this$isInterface$iv = (FirClass)containingDeclaration;
                            boolean $i$f$isInterface = false;
                            ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                            boolean $i$f$isInterface2 = false;
                            if ($this$isInterface$iv$iv == ClassKind.INTERFACE) break block21;
                        }
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirJvmErrors.INSTANCE.getJVM_DEFAULT_NOT_IN_INTERFACE(), (DiagnosticContext)context, null, 8, null);
                        return;
                    }
                    if (FirJvmHelperKt.isJvm6(context)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirJvmErrors.INSTANCE.getJVM_DEFAULT_IN_JVM6_TARGET(), (Object)"JvmDefault", (DiagnosticContext)context, null, 16, null);
                        return;
                    }
                    if (!jvmDefaultMode2.isEnabled()) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirJvmErrors.INSTANCE.getJVM_DEFAULT_IN_DECLARATION(), (Object)"JvmDefault", (DiagnosticContext)context, null, 16, null);
                        return;
                    }
                    break block22;
                }
                FirAnnotation annotationNoCompatibility = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JvmNames.INSTANCE.getJVM_DEFAULT_NO_COMPATIBILITY_CLASS_ID(), session2);
                if (annotationNoCompatibility != null) {
                    KtSourceElement source3 = annotationNoCompatibility.getSource();
                    if (FirJvmHelperKt.isJvm6(context)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source3, FirJvmErrors.INSTANCE.getJVM_DEFAULT_IN_JVM6_TARGET(), (Object)"JvmDefaultWithoutCompatibility", (DiagnosticContext)context, null, 16, null);
                        return;
                    }
                    if (!jvmDefaultMode2.isEnabled()) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source3, FirJvmErrors.INSTANCE.getJVM_DEFAULT_IN_DECLARATION(), (Object)"JvmDefaultWithoutCompatibility", (DiagnosticContext)context, null, 16, null);
                        return;
                    }
                }
                if ((annotationWithCompatibility = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JvmNames.INSTANCE.getJVM_DEFAULT_WITH_COMPATIBILITY_CLASS_ID(), session2)) == null) break block22;
                source = annotationWithCompatibility.getSource();
                if (FirJvmHelperKt.isJvm6(context)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getJVM_DEFAULT_IN_JVM6_TARGET(), (Object)"JvmDefaultWithCompatibility", (DiagnosticContext)context, null, 16, null);
                    return;
                }
                if (jvmDefaultMode2 != JvmDefaultMode.ALL_INCOMPATIBLE) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getJVM_DEFAULT_WITH_COMPATIBILITY_IN_DECLARATION(), (DiagnosticContext)context, null, 8, null);
                    return;
                }
                if (!(declaration instanceof FirRegularClass)) break block23;
                FirClass $this$isInterface$iv = (FirClass)declaration;
                boolean $i$f$isInterface = false;
                ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                boolean $i$f$isInterface3 = false;
                if ($this$isInterface$iv$iv == ClassKind.INTERFACE) break block22;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getJVM_DEFAULT_WITH_COMPATIBILITY_NOT_ON_INTERFACE(), (DiagnosticContext)context, null, 8, null);
            return;
        }
        this.checkNonJvmDefaultOverridesJavaDefault(defaultAnnotation, jvmDefaultMode2, declaration, context, reporter);
    }

    private final void checkNonJvmDefaultOverridesJavaDefault(FirAnnotation defaultAnnotation, JvmDefaultMode jvmDefaultMode2, FirDeclaration declaration, CheckerContext context, DiagnosticReporter reporter) {
        FirClassLikeDeclaration containingDeclaration;
        Object object;
        FirSimpleFunction member2;
        block15: {
            if (defaultAnnotation != null || jvmDefaultMode2.getForAllMethodsWithBody()) {
                return;
            }
            FirSimpleFunction firSimpleFunction = declaration instanceof FirSimpleFunction ? (FirSimpleFunction)declaration : null;
            if (firSimpleFunction == null) {
                return;
            }
            member2 = firSimpleFunction;
            CheckerContext $this$findClosest_u24default$iv = context;
            boolean $i$f$findClosest = false;
            for (FirDeclaration firDeclaration : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirDeclaration firDeclaration2 = firDeclaration;
                if (!(firDeclaration2 instanceof FirClassLikeDeclaration)) {
                    firDeclaration2 = null;
                }
                if ((object = (FirElement)((FirClassLikeDeclaration)firDeclaration2)) == null) continue;
                Object object2 = object;
                FirElement firElement = object2;
                boolean bl = false;
                FirElement firElement2 = firElement;
                object = true ? object2 : null;
                if (object == null) {
                    continue;
                }
                break block15;
            }
            object = null;
        }
        if ((containingDeclaration = (FirClassLikeDeclaration)object) instanceof FirClass) {
            FirClass $this$isInterface$iv = (FirClass)containingDeclaration;
            boolean $i$f$isInterface = false;
            ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
            boolean $i$f$isInterface2 = false;
            boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
            if (bl) {
                boolean bl2;
                List overriddenFunctions2;
                block16: {
                    FirTypeScope unsubstitutedScope = FirHelpersKt.unsubstitutedScope((FirClass)containingDeclaration, context);
                    unsubstitutedScope.processFunctionsByName(member2.getName(), checkNonJvmDefaultOverridesJavaDefault.1.INSTANCE);
                    overriddenFunctions2 = FirTypeScopeKt.getDirectOverriddenFunctions$default(unsubstitutedScope, member2.getSymbol(), false, 2, null);
                    Iterable $this$any$iv = overriddenFunctions2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirNamedFunctionSymbol firNamedFunctionSymbol = (FirNamedFunctionSymbol)element$iv;
                            boolean bl3 = false;
                            if (!(FirAnnotationUtilsKt.getAnnotationByClassId(firNamedFunctionSymbol, JvmNames.INSTANCE.getJVM_DEFAULT_CLASS_ID(), context.getSession()) != null)) continue;
                            bl2 = true;
                            break block16;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getJVM_DEFAULT_REQUIRED_FOR_OVERRIDE(), (DiagnosticContext)context, null, 8, null);
                } else if (jvmDefaultMode2.isEnabled()) {
                    for (FirNamedFunctionSymbol overriddenFunction : overriddenFunctions2) {
                        List<FirCallableSymbol<?>> list2 = this.getOverriddenDeclarations(overriddenFunction);
                        for (FirCallableSymbol firCallableSymbol : list2) {
                            FirClassLikeSymbol<?> containingClassSymbol;
                            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(firCallableSymbol);
                            FirClassLikeSymbol<?> firClassLikeSymbol = containingClassSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context.getSession()) : null;
                            if (!((firClassLikeSymbol != null ? firClassLikeSymbol.getOrigin() : null) instanceof FirDeclarationOrigin.Java)) continue;
                            FirCallableSymbol $this$modality$iv = firCallableSymbol;
                            boolean $i$f$getModality = false;
                            if ($this$modality$iv.getResolvedStatus().getModality() == Modality.ABSTRACT) continue;
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getNON_JVM_DEFAULT_OVERRIDES_JAVA_DEFAULT(), (DiagnosticContext)context, null, 8, null);
                            return;
                        }
                    }
                }
            }
        }
    }

    private final List<FirCallableSymbol<?>> getOverriddenDeclarations(FirCallableSymbol<?> $this$getOverriddenDeclarations) {
        List list2;
        if ($this$getOverriddenDeclarations instanceof FirIntersectionCallableSymbol) {
            list2 = new ArrayList(((FirIntersectionCallableSymbol)((Object)$this$getOverriddenDeclarations)).getIntersections());
        } else {
            ArrayList arrayList;
            ArrayList it = arrayList = new ArrayList(1);
            boolean bl = false;
            it.add($this$getOverriddenDeclarations);
            list2 = arrayList;
        }
        return list2;
    }
}

