/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.analyze;

import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionInterfaceFactoryKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.container.StorageComponentContainer;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.frontend.js.di.InjectionKt;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.ErrorTolerancePolicy;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.resolve.BindingContextSlicesJsKt;
import org.jetbrains.kotlin.js.resolve.JsPlatformAnalyzerServices;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TargetEnvironment;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.extensions.AnalysisHandlerExtension;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J^\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u000eJL\u0010\u0015\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\rJ$\u0010\u001c\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J(\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H$\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/js/analyze/AbstractTopDownAnalyzerFacadeForJS;", "", "()V", "analyzeFiles", "Lorg/jetbrains/kotlin/js/analyzer/JsAnalysisResult;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "moduleDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "friendModuleDescriptors", "targetEnvironment", "Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "thisIsBuiltInsModule", "", "customBuiltInsModule", "analyzeFilesWithGivenTrace", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "moduleContext", "Lorg/jetbrains/kotlin/context/ModuleContext;", "additionalPackages", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "checkForErrors", "allFiles", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "errorPolicy", "Lorg/jetbrains/kotlin/js/config/ErrorTolerancePolicy;", "loadIncrementalCacheMetadata", "incrementalData", "Lorg/jetbrains/kotlin/incremental/js/IncrementalDataProvider;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "js.frontend"})
@SourceDebugExtension(value={"SMAP\nTopDownAnalyzerFacadeForJS.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TopDownAnalyzerFacadeForJS.kt\norg/jetbrains/kotlin/js/analyze/AbstractTopDownAnalyzerFacadeForJS\n+ 2 Dsl.kt\norg/jetbrains/kotlin/container/DslKt\n*L\n1#1,226:1\n37#2:227\n*S KotlinDebug\n*F\n+ 1 TopDownAnalyzerFacadeForJS.kt\norg/jetbrains/kotlin/js/analyze/AbstractTopDownAnalyzerFacadeForJS\n*L\n143#1:227\n*E\n"})
public abstract class AbstractTopDownAnalyzerFacadeForJS {
    @NotNull
    public final JsAnalysisResult analyzeFiles(@NotNull Collection<? extends KtFile> files2, @NotNull Project project, @NotNull CompilerConfiguration configuration2, @NotNull List<? extends ModuleDescriptor> moduleDescriptors, @NotNull List<? extends ModuleDescriptor> friendModuleDescriptors, @NotNull TargetEnvironment targetEnvironment, boolean thisIsBuiltInsModule, @Nullable ModuleDescriptor customBuiltInsModule) {
        KotlinBuiltIns kotlinBuiltIns;
        Intrinsics.checkNotNullParameter(files2, "files");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(moduleDescriptors, "moduleDescriptors");
        Intrinsics.checkNotNullParameter(friendModuleDescriptors, "friendModuleDescriptors");
        Intrinsics.checkNotNullParameter(targetEnvironment, "targetEnvironment");
        if (!(!thisIsBuiltInsModule || customBuiltInsModule == null)) {
            boolean $i$a$-require-AbstractTopDownAnalyzerFacadeForJS$analyzeFiles$22 = false;
            String $i$a$-require-AbstractTopDownAnalyzerFacadeForJS$analyzeFiles$22 = "Can't simultaneously use custom built-ins module and set current module as built-ins";
            throw new IllegalArgumentException($i$a$-require-AbstractTopDownAnalyzerFacadeForJS$analyzeFiles$22.toString());
        }
        if (thisIsBuiltInsModule) {
            kotlinBuiltIns = new DefaultBuiltIns(false);
        } else {
            ModuleDescriptor moduleDescriptor = customBuiltInsModule;
            kotlinBuiltIns = moduleDescriptor != null ? moduleDescriptor.getBuiltIns() : JsPlatformAnalyzerServices.INSTANCE.getBuiltIns();
        }
        KotlinBuiltIns builtIns = kotlinBuiltIns;
        String string2 = configuration2.get(CommonConfigurationKeys.MODULE_NAME);
        Intrinsics.checkNotNull(string2);
        String moduleName = string2;
        ProjectContext projectContext = ContextKt.ProjectContext(project, "TopDownAnalyzer for JS");
        Name name = Name.special('<' + moduleName + '>');
        Intrinsics.checkNotNullExpressionValue(name, "special(\"<$moduleName>\")");
        MutableModuleContext context = ContextKt.ContextForNewModule$default(projectContext, name, builtIns, JsPlatforms.INSTANCE.getDefaultJsPlatform(), null, 16, null);
        List additionalPackages = new ArrayList();
        if (thisIsBuiltInsModule) {
            builtIns.setBuiltInsModule(context.getModule());
            ((Collection)additionalPackages).add(FunctionInterfaceFactoryKt.functionInterfacePackageFragmentProvider(context.getStorageManager(), context.getModule()));
        }
        ModuleDescriptorImpl[] moduleDescriptorImplArray = new ModuleDescriptorImpl[]{context.getModule()};
        Set<ModuleDescriptorImpl> set = SetsKt.plus(SetsKt.mutableSetOf(moduleDescriptorImplArray), (Iterable)moduleDescriptors);
        ModuleDescriptorImpl moduleDescriptorImpl = builtIns.getBuiltInsModule();
        Intrinsics.checkNotNullExpressionValue(moduleDescriptorImpl, "builtIns.builtInsModule");
        Set<ModuleDescriptorImpl> dependencies2 = SetsKt.plus(set, moduleDescriptorImpl);
        ModuleDescriptorImpl moduleDescriptorImpl2 = context.getModule();
        List<ModuleDescriptorImpl> list2 = CollectionsKt.toList((Iterable)dependencies2);
        Intrinsics.checkNotNull(list2, "null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl>");
        Set<ModuleDescriptorImpl> set2 = CollectionsKt.toSet((Iterable)friendModuleDescriptors);
        Intrinsics.checkNotNull(set2, "null cannot be cast to non-null type kotlin.collections.Set<org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl>");
        moduleDescriptorImpl2.setDependencies(list2, set2);
        ModuleKind moduleKind = configuration2.get(JSConfigurationKeys.MODULE_KIND, ModuleKind.PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)moduleKind, "configuration.get(JSConf\u2026E_KIND, ModuleKind.PLAIN)");
        ModuleKind moduleKind2 = moduleKind;
        BindingTraceContext trace = new BindingTraceContext();
        trace.record(BindingContextSlicesJsKt.MODULE_KIND, context.getModule(), moduleKind2);
        return this.analyzeFilesWithGivenTrace(files2, trace, context, configuration2, targetEnvironment, project, additionalPackages);
    }

    public static /* synthetic */ JsAnalysisResult analyzeFiles$default(AbstractTopDownAnalyzerFacadeForJS abstractTopDownAnalyzerFacadeForJS, Collection collection, Project project, CompilerConfiguration compilerConfiguration, List list2, List list3, TargetEnvironment targetEnvironment, boolean bl, ModuleDescriptor moduleDescriptor, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: analyzeFiles");
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        if ((n & 0x80) != 0) {
            moduleDescriptor = null;
        }
        return abstractTopDownAnalyzerFacadeForJS.analyzeFiles(collection, project, compilerConfiguration, list2, list3, targetEnvironment, bl, moduleDescriptor);
    }

    @NotNull
    protected abstract PackageFragmentProvider loadIncrementalCacheMetadata(@NotNull IncrementalDataProvider var1, @NotNull ModuleContext var2, @NotNull LookupTracker var3, @NotNull LanguageVersionSettings var4);

    @NotNull
    public final JsAnalysisResult analyzeFilesWithGivenTrace(@NotNull Collection<? extends KtFile> files2, @NotNull BindingTrace trace, @NotNull ModuleContext moduleContext, @NotNull CompilerConfiguration configuration2, @NotNull TargetEnvironment targetEnvironment, @NotNull Project project, @NotNull List<? extends PackageFragmentProvider> additionalPackages) {
        JsAnalysisResult jsAnalysisResult;
        Object object;
        Object object2;
        Object result2;
        block13: {
            Object object3;
            Object object4;
            List analysisHandlerExtensions;
            StorageComponentContainer container;
            block12: {
                PackageFragmentProvider packageFragmentProvider2;
                Intrinsics.checkNotNullParameter(files2, "files");
                Intrinsics.checkNotNullParameter(trace, "trace");
                Intrinsics.checkNotNullParameter(moduleContext, "moduleContext");
                Intrinsics.checkNotNullParameter(configuration2, "configuration");
                Intrinsics.checkNotNullParameter(targetEnvironment, "targetEnvironment");
                Intrinsics.checkNotNullParameter(project, "project");
                Intrinsics.checkNotNullParameter(additionalPackages, "additionalPackages");
                LookupTracker lookupTracker = configuration2.get(CommonConfigurationKeys.LOOKUP_TRACKER);
                if (lookupTracker == null) {
                    lookupTracker = LookupTracker.DO_NOTHING.INSTANCE;
                }
                Intrinsics.checkNotNullExpressionValue(lookupTracker, "configuration.get(Common\u2026 LookupTracker.DO_NOTHING");
                LookupTracker lookupTracker2 = lookupTracker;
                ExpectActualTracker expectActualTracker = configuration2.get(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER);
                if (expectActualTracker == null) {
                    expectActualTracker = ExpectActualTracker.DoNothing.INSTANCE;
                }
                Intrinsics.checkNotNullExpressionValue(expectActualTracker, "configuration.get(Common\u2026ctActualTracker.DoNothing");
                ExpectActualTracker expectActualTracker2 = expectActualTracker;
                InlineConstTracker inlineConstTracker = configuration2.get(CommonConfigurationKeys.INLINE_CONST_TRACKER);
                if (inlineConstTracker == null) {
                    inlineConstTracker = InlineConstTracker.DoNothing.INSTANCE;
                }
                Intrinsics.checkNotNullExpressionValue(inlineConstTracker, "configuration.get(Common\u2026ineConstTracker.DoNothing");
                InlineConstTracker inlineConstTracker2 = inlineConstTracker;
                EnumWhenTracker enumWhenTracker = configuration2.get(CommonConfigurationKeys.ENUM_WHEN_TRACKER);
                if (enumWhenTracker == null) {
                    enumWhenTracker = EnumWhenTracker.DoNothing.INSTANCE;
                }
                Intrinsics.checkNotNullExpressionValue(enumWhenTracker, "configuration.get(Common\u2026EnumWhenTracker.DoNothing");
                EnumWhenTracker enumWhenTracker2 = enumWhenTracker;
                LanguageVersionSettings languageVersionSettings2 = CommonConfigurationKeysKt.getLanguageVersionSettings(configuration2);
                IncrementalDataProvider incrementalDataProvider = configuration2.get(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER);
                if (incrementalDataProvider != null) {
                    IncrementalDataProvider it = incrementalDataProvider;
                    boolean bl = false;
                    packageFragmentProvider2 = this.loadIncrementalCacheMetadata(it, moduleContext, lookupTracker2, languageVersionSettings2);
                } else {
                    packageFragmentProvider2 = null;
                }
                PackageFragmentProvider packageFragment = packageFragmentProvider2;
                container = InjectionKt.createContainerForJS(moduleContext, trace, new FileBasedDeclarationProviderFactory(moduleContext.getStorageManager(), files2), languageVersionSettings2, lookupTracker2, expectActualTracker2, inlineConstTracker2, enumWhenTracker2, CollectionsKt.plus((Collection)additionalPackages, (Iterable)CollectionsKt.listOfNotNull(packageFragment)), targetEnvironment);
                analysisHandlerExtensions = AnalysisHandlerExtension.Companion.getInstances(project);
                for (Object extension : (Iterable)analysisHandlerExtensions) {
                    boolean bl = false;
                    if ((extension = extension.doAnalysis(project, moduleContext.getModule(), moduleContext, files2, trace, container)) == null) continue;
                    object4 = extension;
                    break block12;
                }
                object4 = object3 = null;
            }
            if (object4 == null) {
                AbstractTopDownAnalyzerFacadeForJS $this$analyzeFilesWithGivenTrace_u24lambda_u243 = this;
                boolean bl = false;
                ComponentProvider $this$get$iv = container;
                boolean $i$f$get = false;
                LazyTopDownAnalyzer.analyzeDeclarations$default(DslKt.getService($this$get$iv, LazyTopDownAnalyzer.class), TopDownAnalysisMode.TopLevelDeclarations, files2, null, null, 12, null);
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
                object3 = AnalysisResult.Companion.success(bindingContext, moduleContext.getModule());
            }
            result2 = object3;
            for (AnalysisHandlerExtension extension : (Iterable)analysisHandlerExtensions) {
                boolean bl = false;
                AnalysisResult analysisResult2 = extension.analysisCompleted(project, moduleContext.getModule(), trace, files2);
                if (analysisResult2 == null) continue;
                object2 = analysisResult2;
                break block13;
            }
            object2 = object = null;
        }
        if (object2 == null) {
            object = result2;
        }
        if ((result2 = object) instanceof JsAnalysisResult) {
            jsAnalysisResult = (JsAnalysisResult)result2;
        } else {
            DelegatingBindingTrace bindingTrace = new DelegatingBindingTrace(((AnalysisResult)result2).getBindingContext(), "DelegatingBindingTrace by AnalysisHandlerExtension", false, null, false, null, 60, null);
            jsAnalysisResult = result2 instanceof AnalysisResult.RetryWithAdditionalRoots ? (JsAnalysisResult)new JsAnalysisResult.RetryWithAdditionalRoots((BindingTrace)bindingTrace, ((AnalysisResult)result2).getModuleDescriptor(), ((AnalysisResult.RetryWithAdditionalRoots)result2).getAdditionalKotlinRoots()) : JsAnalysisResult.Companion.success(bindingTrace, ((AnalysisResult)result2).getModuleDescriptor(), ((AnalysisResult)result2).getShouldGenerateCode());
        }
        return jsAnalysisResult;
    }

    public static /* synthetic */ JsAnalysisResult analyzeFilesWithGivenTrace$default(AbstractTopDownAnalyzerFacadeForJS abstractTopDownAnalyzerFacadeForJS, Collection collection, BindingTrace bindingTrace, ModuleContext moduleContext, CompilerConfiguration compilerConfiguration, TargetEnvironment targetEnvironment, Project project, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: analyzeFilesWithGivenTrace");
        }
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return abstractTopDownAnalyzerFacadeForJS.analyzeFilesWithGivenTrace(collection, bindingTrace, moduleContext, compilerConfiguration, targetEnvironment, project, list2);
    }

    public final boolean checkForErrors(@NotNull Collection<? extends KtFile> allFiles, @NotNull BindingContext bindingContext, @NotNull ErrorTolerancePolicy errorPolicy) {
        Intrinsics.checkNotNullParameter(allFiles, "allFiles");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Intrinsics.checkNotNullParameter((Object)errorPolicy, "errorPolicy");
        boolean hasErrors = false;
        try {
            AnalyzingUtils.INSTANCE.throwExceptionOnErrors(bindingContext);
        }
        catch (Exception ex) {
            if (!errorPolicy.getAllowSemanticErrors()) {
                throw ex;
            }
            hasErrors = true;
        }
        try {
            for (KtFile ktFile : allFiles) {
                AnalyzingUtils.checkForSyntacticErrors(ktFile);
            }
        }
        catch (Exception ex) {
            if (!errorPolicy.getAllowSyntaxErrors()) {
                throw ex;
            }
            hasErrors = true;
        }
        return hasErrors;
    }
}

