/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.resolve.calls.components.candidate.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.AbstractFakeOverrideSuperCall;
import org.jetbrains.kotlin.resolve.calls.model.AbstractSuperCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionPart;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SuperAsExtensionReceiver;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\b\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/CheckSuperExpressionCallPart;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolutionPart;", "()V", "checkSuperCandidateDescriptor", "", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;", "candidateDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "process", "workIndex", "", "resolution"})
@SourceDebugExtension(value={"SMAP\nResolutionParts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionParts.kt\norg/jetbrains/kotlin/resolve/calls/components/CheckSuperExpressionCallPart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,961:1\n288#2,2:962\n*S KotlinDebug\n*F\n+ 1 ResolutionParts.kt\norg/jetbrains/kotlin/resolve/calls/components/CheckSuperExpressionCallPart\n*L\n830#1:962,2\n*E\n"})
public final class CheckSuperExpressionCallPart
extends ResolutionPart {
    @NotNull
    public static final CheckSuperExpressionCallPart INSTANCE = new CheckSuperExpressionCallPart();

    private CheckSuperExpressionCallPart() {
    }

    @Override
    public void process(@NotNull ResolutionCandidate $this$process, int workIndex) {
        SimpleKotlinCallArgument extensionReceiver;
        Intrinsics.checkNotNullParameter($this$process, "<this>");
        CallableDescriptor candidateDescriptor = $this$process.getResolvedCall().getCandidateDescriptor();
        if ($this$process.getCallComponents().getStatelessCallbacks().isSuperExpression($this$process.getResolvedCall().getDispatchReceiverArgument()) && candidateDescriptor instanceof CallableMemberDescriptor) {
            this.checkSuperCandidateDescriptor($this$process, (CallableMemberDescriptor)candidateDescriptor);
        }
        if ((extensionReceiver = $this$process.getResolvedCall().getExtensionReceiverArgument()) != null && $this$process.getCallComponents().getStatelessCallbacks().isSuperExpression(extensionReceiver)) {
            $this$process.addDiagnostic(new SuperAsExtensionReceiver(extensionReceiver));
        }
    }

    private final void checkSuperCandidateDescriptor(ResolutionCandidate $this$checkSuperCandidateDescriptor, CallableMemberDescriptor candidateDescriptor) {
        if (candidateDescriptor.getModality() == Modality.ABSTRACT) {
            SimpleKotlinCallArgument simpleKotlinCallArgument = $this$checkSuperCandidateDescriptor.getResolvedCall().getDispatchReceiverArgument();
            Intrinsics.checkNotNull(simpleKotlinCallArgument);
            $this$checkSuperCandidateDescriptor.addDiagnostic(new AbstractSuperCall(simpleKotlinCallArgument));
        } else if (candidateDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            CallableMemberDescriptor intersectionFakeOverrideDescriptor = candidateDescriptor;
            while (intersectionFakeOverrideDescriptor.getOverriddenDescriptors().size() == 1) {
                Collection<? extends CallableMemberDescriptor> collection = intersectionFakeOverrideDescriptor.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(collection, "intersectionFakeOverride\u2026tor.overriddenDescriptors");
                Object t = CollectionsKt.first((Iterable)collection);
                Intrinsics.checkNotNullExpressionValue(t, "intersectionFakeOverride\u2026riddenDescriptors.first()");
                intersectionFakeOverrideDescriptor = (CallableMemberDescriptor)t;
                if (intersectionFakeOverrideDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) continue;
                return;
            }
            if (intersectionFakeOverrideDescriptor.getOverriddenDescriptors().size() > 1) {
                Object v4;
                block7: {
                    Collection<? extends CallableMemberDescriptor> collection = intersectionFakeOverrideDescriptor.getOverriddenDescriptors();
                    Intrinsics.checkNotNullExpressionValue(collection, "intersectionFakeOverride\u2026tor.overriddenDescriptors");
                    Iterable $this$firstOrNull$iv = collection;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue(it, "it");
                        if (!(!DescriptorUtilsKt.isInsideInterface(it))) continue;
                        v4 = element$iv;
                        break block7;
                    }
                    v4 = null;
                }
                CallableMemberDescriptor callableMemberDescriptor = v4;
                if ((callableMemberDescriptor != null ? callableMemberDescriptor.getModality() : null) == Modality.ABSTRACT) {
                    $this$checkSuperCandidateDescriptor.addDiagnostic(AbstractFakeOverrideSuperCall.INSTANCE);
                }
            }
        }
    }
}

