/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.JsCodeOutlineTransformer;
import org.jetbrains.kotlin.ir.backend.js.lower.JsCodeOutliningLoweringKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsCodeOutliningLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "backendContext", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "putOutlinedFunctionsIntoContainer", "outlinedFunctions", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Companion", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsCodeOutliningLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsCodeOutliningLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsCodeOutliningLowering\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,390:1\n16#2,2:391\n383#3,13:393\n98#4,2:406\n*S KotlinDebug\n*F\n+ 1 JsCodeOutliningLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsCodeOutliningLowering\n*L\n102#1:391,2\n110#1:393,13\n110#1:406,2\n*E\n"})
public final class JsCodeOutliningLowering
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsIrBackendContext backendContext;
    @NotNull
    private static final IrDeclarationOriginImpl OUTLINED_JS_CODE_ORIGIN = new IrDeclarationOriginImpl("OUTLINED_JS_CODE", false, 2, null);

    public JsCodeOutliningLowering(@NotNull JsIrBackendContext backendContext) {
        Intrinsics.checkNotNullParameter(backendContext, "backendContext");
        this.backendContext = backendContext;
    }

    @NotNull
    public final JsIrBackendContext getBackendContext() {
        return this.backendContext;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        if (!JsCodeOutliningLoweringKt.access$containsCallsTo(irBody, this.backendContext.getIntrinsics().getJsCode())) {
            return;
        }
        JsCodeOutlineTransformer replacer = new JsCodeOutlineTransformer(this.backendContext, container);
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, replacer);
        List<IrFunction> outlinedFunctions = replacer.getOutlinedFunctions();
        if (outlinedFunctions.isEmpty()) {
            return;
        }
        this.putOutlinedFunctionsIntoContainer(outlinedFunctions, container, irBody);
    }

    /*
     * WARNING - void declaration
     */
    private final void putOutlinedFunctionsIntoContainer(List<? extends IrFunction> outlinedFunctions, IrDeclaration container, IrBody irBody) {
        IrElementBase irElementBase;
        for (IrFunction irFunction : outlinedFunctions) {
            Object v0;
            block8: {
                void $this$firstIsInstanceOrNull$iv;
                Sequence<IrDeclaration> sequence2 = IrUtilsKt.getParentDeclarationsWithSelf(container);
                irElementBase = irFunction;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof IrDeclarationParent)) continue;
                    v0 = element$iv;
                    break block8;
                }
                v0 = null;
            }
            IrDeclarationParent irDeclarationParent = v0;
            if (irDeclarationParent == null) {
                CompilationExceptionKt.compilationException("Unexpected container to insert the outlined function to", container);
                throw new KotlinNothingValueException();
            }
            ((IrDeclarationBase)irElementBase).setParent(irDeclarationParent);
        }
        IrBody irBody2 = irBody;
        if (irBody2 instanceof IrBlockBody) {
            ((IrBlockBody)irBody).getStatements().addAll(0, (Collection<IrStatement>)outlinedFunctions);
        } else if (irBody2 instanceof IrExpressionBody) {
            void $this$putOutlinedFunctionsIntoContainer_u24lambda_u240;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlock_u24default$iv;
            DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder$default(this.backendContext, container.getSymbol(), 0, 0, 6, null);
            IrBuilderWithScope irBuilderWithScope = declarationIrBuilder;
            int $this$firstIsInstanceOrNull$iv = irBody.getStartOffset();
            int endOffset$iv = irBody.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void var14_17 = this_$iv$iv;
            irElementBase = (IrExpressionBody)irBody;
            boolean bl = false;
            $this$putOutlinedFunctionsIntoContainer_u24lambda_u240.unaryPlus(outlinedFunctions);
            $this$putOutlinedFunctionsIntoContainer_u24lambda_u240.unaryPlus(((IrExpressionBody)irBody).getExpression());
            ((IrExpressionBody)irElementBase).setExpression(this_$iv$iv.doBuild());
        } else {
            if (irBody2 instanceof IrSyntheticBody) {
                org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.syntheticBodyIsNotSupported(container);
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsCodeOutliningLowering$Companion;", "", "<init>", "()V", "OUTLINED_JS_CODE_ORIGIN", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "getOUTLINED_JS_CODE_ORIGIN", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "backend.js"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrDeclarationOriginImpl getOUTLINED_JS_CODE_ORIGIN() {
            return OUTLINED_JS_CODE_ORIGIN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

