/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cli.io.support;

import io.micronaut.cli.io.support.AbstractFileResolvingResource;
import io.micronaut.cli.io.support.Resource;
import io.micronaut.cli.io.support.ResourceUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

public class UrlResource
extends AbstractFileResolvingResource {
    private final URL url;
    private final URL cleanedUrl;
    private final URI uri;

    public UrlResource(URL url) {
        this.url = url;
        this.cleanedUrl = this.getCleanedUrl(url, url.toString());
        this.uri = null;
    }

    public UrlResource(URI uri) throws MalformedURLException {
        this.url = uri.toURL();
        this.cleanedUrl = this.getCleanedUrl(this.url, uri.toString());
        this.uri = uri;
    }

    public UrlResource(String path) throws MalformedURLException {
        this.url = new URL(path);
        this.cleanedUrl = this.getCleanedUrl(this.url, path);
        this.uri = null;
    }

    private URL getCleanedUrl(URL originalUrl, String originalPath) {
        try {
            return new URL(ResourceUtils.cleanPath(originalPath));
        }
        catch (MalformedURLException ex) {
            return originalUrl;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URLConnection con = this.url.openConnection();
        UrlResource.useCachesIfNecessary(con);
        try {
            return con.getInputStream();
        }
        catch (IOException ex) {
            if (con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).disconnect();
            }
            throw ex;
        }
    }

    private static void useCachesIfNecessary(URLConnection con) {
        con.setUseCaches(con.getClass().getName().startsWith("JNLP"));
    }

    @Override
    public URL getURL() throws IOException {
        return this.url;
    }

    @Override
    public URI getURI() throws IOException {
        if (this.uri != null) {
            return this.uri;
        }
        return this.getFile().toURI();
    }

    @Override
    public File getFile() throws IOException {
        return this.uri == null ? super.getFile() : super.getFile(this.uri);
    }

    @Override
    public Resource createRelative(String relativePath) {
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        try {
            return new UrlResource(new URL(this.url, relativePath));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public String getFilename() {
        return new File(this.url.getFile()).getName();
    }

    @Override
    public String getDescription() {
        return "URL [" + this.url + "]";
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof UrlResource && this.cleanedUrl.equals(((UrlResource)obj).cleanedUrl);
    }

    public int hashCode() {
        return this.cleanedUrl.hashCode();
    }

    public String toString() {
        return this.getDescription();
    }
}

