/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;

namespace PostgreSql.Data.PgSqlClient.DbSchema
{
	internal class PgDbSchemaFactory
	{
		public static IDbSchema GetSchema(PgDbSchemaType schema)
		{
			IDbSchema returnSchema = null;

			switch(schema)
			{
				case PgDbSchemaType.Aggregates: 
					returnSchema = new PgAggregatesSchema();
					break;

				case PgDbSchemaType.Casts: 
					returnSchema = new PgCastsSchema();
					break;

				case PgDbSchemaType.Check_Constraints:
					returnSchema = new PgCheckConstraintsSchema();
					break;

				case PgDbSchemaType.Check_Constraints_By_Table:
					returnSchema = new PgCheckConstraintsByTableSchema();
					break;

				case PgDbSchemaType.Columns:
					returnSchema = new PgColumnsSchema();
					break;

				case PgDbSchemaType.Database:
					returnSchema = new PgDatabaseSchema();
					break;

				case PgDbSchemaType.Domains:
					returnSchema = new PgDomainsSchema();
					break;

				case PgDbSchemaType.Foreign_Keys:
					returnSchema = new PgForeignKeysSchema();
					break;

				case PgDbSchemaType.Groups:
					returnSchema = new PgGroupsSchema();
					break;

				case PgDbSchemaType.Indexes:
					returnSchema = new PgIndexesSchema();
					break;

				case PgDbSchemaType.Primary_Keys: 
					returnSchema = new PgPrimaryKeysSchema();
					break;

				case PgDbSchemaType.Function_Privileges:
					returnSchema = new PgFunctionPrivilegesSchema();
					break;

				case PgDbSchemaType.Functions:
					returnSchema = new PgFunctionsSchema();
					break;

				case PgDbSchemaType.Provider_Types:
					returnSchema = new PgProviderTypesSchema();
					break;

				case PgDbSchemaType.Schemata: 	
					returnSchema = new PgSchemataSchema();
					break;

				case PgDbSchemaType.Sql_Languages: 
					returnSchema = new PgSqlLanguagesSchema();
					break;

				case PgDbSchemaType.Statistics: 
					break;

				case PgDbSchemaType.Tables: 
					returnSchema = new PgTablesSchema();
					break;

				case PgDbSchemaType.Table_Constraint:
					returnSchema = new PgTableConstraintsSchema();
					break;

				case PgDbSchemaType.Tables_Info: 
					break;

				case PgDbSchemaType.Table_Privileges:
					returnSchema = new PgTablePrivilegesSchema();					
					break;

				case PgDbSchemaType.Table_Statistics:
					break;

				case PgDbSchemaType.Triggers: 
					returnSchema = new PgTriggersSchema();
					break;

				case PgDbSchemaType.Trigger_Parameters:
					break;

				case PgDbSchemaType.Trigger_Privileges: 
					break;

				case PgDbSchemaType.Users:
					returnSchema = new PgUsersSchema();
					break;

				case PgDbSchemaType.Views:
					returnSchema = new PgViewsSchema();
					break;

				case PgDbSchemaType.View_Privileges:
					returnSchema = new PgViewPrivilegesSchema();
					break;
			}

			return returnSchema;
		}
	}
}