/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

import apex.jorje.data.Location;

public abstract class AnnotationValue {
    private AnnotationValue() {
    }

    public static final AnnotationValue _TrueAnnotationValue(Location loc) {
        return new TrueAnnotationValue(loc);
    }

    public static final AnnotationValue _FalseAnnotationValue(Location loc) {
        return new FalseAnnotationValue(loc);
    }

    public static final AnnotationValue _StringAnnotationValue(Location loc, String value) {
        return new StringAnnotationValue(loc, value);
    }

    public abstract <ResultType> ResultType match(MatchBlock<ResultType> var1);

    public abstract void _switch(SwitchBlock var1);

    public static final class StringAnnotationValue
    extends AnnotationValue {
        public Location loc;
        public String value;

        public StringAnnotationValue(Location loc, String value) {
            this.loc = loc;
            this.value = value;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringAnnotationValue other = (StringAnnotationValue)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "StringAnnotationValue(loc = " + this.loc + ", value = " + this.value + ")";
        }
    }

    public static final class FalseAnnotationValue
    extends AnnotationValue {
        public Location loc;

        public FalseAnnotationValue(Location loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FalseAnnotationValue other = (FalseAnnotationValue)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "FalseAnnotationValue(loc = " + this.loc + ")";
        }
    }

    public static final class TrueAnnotationValue
    extends AnnotationValue {
        public Location loc;

        public TrueAnnotationValue(Location loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TrueAnnotationValue other = (TrueAnnotationValue)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "TrueAnnotationValue(loc = " + this.loc + ")";
        }
    }

    public static abstract class SwitchBlockWithDefault
    implements SwitchBlock {
        @Override
        public void _case(TrueAnnotationValue x) {
            this._default(x);
        }

        @Override
        public void _case(FalseAnnotationValue x) {
            this._default(x);
        }

        @Override
        public void _case(StringAnnotationValue x) {
            this._default(x);
        }

        protected abstract void _default(AnnotationValue var1);
    }

    public static interface SwitchBlock {
        public void _case(TrueAnnotationValue var1);

        public void _case(FalseAnnotationValue var1);

        public void _case(StringAnnotationValue var1);
    }

    public static abstract class MatchBlockWithDefault<ResultType>
    implements MatchBlock<ResultType> {
        @Override
        public ResultType _case(TrueAnnotationValue x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(FalseAnnotationValue x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(StringAnnotationValue x) {
            return this._default(x);
        }

        protected abstract ResultType _default(AnnotationValue var1);
    }

    public static interface MatchBlock<ResultType> {
        public ResultType _case(TrueAnnotationValue var1);

        public ResultType _case(FalseAnnotationValue var1);

        public ResultType _case(StringAnnotationValue var1);
    }
}

