/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.converter;

import apex.jorje.lsp.impl.index.converter.TypeIdConverter;
import apex.jorje.lsp.impl.index.converter.TypeInfoConverter;
import apex.jorje.lsp.impl.index.node.ApexField;
import apex.jorje.lsp.impl.index.node.ApexType;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.lsp.impl.index.node.SObjectField;
import apex.jorje.semantic.ast.modifier.Modifier;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.ImmutableSet;
import java.util.List;

final class FieldConverter {
    private final TypeIdConverter idConverter;
    private static final String ID_FIELD_NAME = "id";
    private static final ImmutableSet<String> predefinedApexTypes = ImmutableSet.of("blob", "boolean", "date", "datetime", "decimal", "double", new String[]{"id", "integer", "long", "object", "sobject", "string", "time", "location", "address"});

    FieldConverter(TypeIdConverter idConverter) {
        this.idConverter = idConverter;
    }

    void addField(FieldInfo fieldInfo, ApexType owner, boolean isSObject) {
        ApexField field = isSObject ? new SObjectField(owner) : new ApexField(owner);
        field.setFieldName(fieldInfo.getName());
        List<Modifier> modifiers = fieldInfo.getModifiers().copy().getModifiers();
        field.setModifiers(TypeInfoConverter.stringifyModifiers(modifiers));
        field.setMemberType(fieldInfo.getMemberType().toString());
        ApexTypeId type = this.idConverter.getOrCreateTypeId(fieldInfo.getType());
        if (isSObject) {
            ((SObjectField)field).setIsPrimaryKey(this.isPrimaryKey(fieldInfo));
            ((SObjectField)field).setCatgory(this.getCategory(fieldInfo).getValue());
        }
        field.setType(type);
    }

    private boolean isPrimaryKey(FieldInfo field) {
        return field.getName().toLowerCase().equals(ID_FIELD_NAME);
    }

    private boolean isPredefinedFieldType(String fieldType) {
        return predefinedApexTypes.contains(fieldType.toLowerCase());
    }

    private boolean isPossibleAggregateList(TypeInfo fieldType) {
        return fieldType.getTypeArguments().size() == 1 && fieldType instanceof GenericTypeInfo && ((GenericTypeInfo)fieldType).getUnreifiedType().getApexName().toLowerCase().equals("list");
    }

    private String getListTypeParameter(TypeInfo fieldType) {
        return fieldType.getTypeArguments().get(0).getApexName();
    }

    private SObjectFieldInfo.Category getCategory(FieldInfo field) {
        TypeInfo fieldType = field.getType();
        if (this.isPossibleAggregateList(fieldType)) {
            String targetType = this.getListTypeParameter(fieldType);
            return this.isPredefinedFieldType(targetType) ? SObjectFieldInfo.Category.REGULAR : SObjectFieldInfo.Category.AGGREGATE;
        }
        return this.isPredefinedFieldType(fieldType.getApexName()) ? SObjectFieldInfo.Category.REGULAR : SObjectFieldInfo.Category.FOREIGN_KEY;
    }
}

