/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.node;

import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NdNode;
import org.eclipse.jdt.internal.core.nd.db.IndexException;
import org.eclipse.jdt.internal.core.nd.field.FieldManyToOne;
import org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.eclipse.jdt.internal.core.nd.field.StructDef;

public abstract class ApexTreeNode
extends NdNode {
    public static final StructDef<ApexTreeNode> type = StructDef.create(ApexTreeNode.class, (StructDef)NdNode.type);
    private static final FieldManyToOne<ApexTreeNode> PARENT = FieldManyToOne.create(type, null);
    private static final FieldOneToMany<ApexTreeNode> CHILDREN = FieldOneToMany.create(type, PARENT, (int)16);

    ApexTreeNode(Nd nd, long address) {
        super(nd, address);
    }

    ApexTreeNode(Nd nd, ApexTreeNode parent) {
        super(nd);
        PARENT.put(nd, this.address, parent == null ? 0L : parent.address);
    }

    public int getChildrenCount() {
        return CHILDREN.size(this.getNd(), this.address);
    }

    public ApexTreeNode getChild(int index) {
        return (ApexTreeNode)CHILDREN.get(this.getNd(), this.address, index);
    }

    public <T extends ApexTreeNode> T getAncestorOfType(Class<T> ancestorType) {
        long targetType = this.getNd().getNodeType(ancestorType);
        Nd nd = this.getNd();
        long current = PARENT.getAddress(nd, this.address);
        while (current != 0L) {
            short currentType = NODE_TYPE.get(nd, current);
            if ((long)currentType == targetType) {
                NdNode result = ApexTreeNode.load((Nd)nd, (long)current);
                if (ancestorType.isInstance(result)) {
                    return (T)((Object)((ApexTreeNode)result));
                }
                throw new IndexException("The node at address " + current + " should have been an instance of " + ancestorType.getName() + " but was an instance of " + result.getClass().getName());
            }
            current = PARENT.getAddress(nd, current);
        }
        return null;
    }

    ApexTreeNode getParentNode() {
        return (ApexTreeNode)PARENT.get(this.getNd(), this.address);
    }

    static {
        type.done();
    }
}

