/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.visitors;

import apex.common.base.MoreStrings;
import apex.jorje.lsp.impl.visitors.DocCommentScope;
import apex.jorje.parser.impl.HiddenToken;
import apex.jorje.parser.impl.HiddenTokens;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.modifier.Annotation;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.SignatureEquivalence;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import java.util.List;
import java.util.Map;

public class DocCommentVisitor
extends AstVisitor<DocCommentScope> {
    @Override
    protected boolean defaultVisit() {
        return true;
    }

    @Override
    public void visitEnd(UserClass node, DocCommentScope scope) {
        super.visit(node, scope);
        if (scope.getSymbol().isRight()) {
            return;
        }
        this.processType(node, node.getModifiers().getModifiers().getAnnotations(), scope);
    }

    @Override
    public void visitEnd(UserInterface node, DocCommentScope scope) {
        super.visit(node, scope);
        if (scope.getSymbol().isRight()) {
            return;
        }
        this.processType(node, node.getModifiers().getModifiers().getAnnotations(), scope);
    }

    @Override
    public void visitEnd(UserEnum node, DocCommentScope scope) {
        super.visit(node, scope);
        if (scope.getSymbol().isRight()) {
            return;
        }
        this.processType(node, node.getModifiers().getModifiers().getAnnotations(), scope);
    }

    @Override
    public void visitEnd(Field node, DocCommentScope scope) {
        super.visit(node, scope);
        if (scope.getSymbol().isLeft() || ((Member)scope.getSymbol().getRight()).getMemberType() != Member.Type.FIELD) {
            return;
        }
        FieldInfo fieldInfo = node.getFieldInfo();
        FieldInfo referenceFieldInfo = (FieldInfo)scope.getSymbol().getRight();
        if (fieldInfo != null && MoreStrings.equalsIgnoreCase(fieldInfo.getBytecodeName(), referenceFieldInfo.getBytecodeName())) {
            this.setCommentIfExists(scope, node.getModifiers().getModifiers().getAnnotations(), node);
        }
    }

    @Override
    public void visitEnd(Method node, DocCommentScope scope) {
        super.visit(node, scope);
        if (scope.getSymbol().isLeft() || ((Member)scope.getSymbol().getRight()).getMemberType() != Member.Type.METHOD) {
            return;
        }
        MethodInfo methodInfo = node.getMethodInfo();
        MethodInfo referenceMethodInfo = (MethodInfo)scope.getSymbol().getRight();
        if (methodInfo != null && SignatureEquivalence.isEquivalent(methodInfo.getSignature(), referenceMethodInfo.getSignature())) {
            this.setCommentIfExists(scope, node.getModifiers().getAnnotations(), node);
        }
    }

    private int getEndLine(HiddenToken value) {
        return value.getLocation().getLine() + (int)value.getValue().chars().filter(s -> s == 10).count();
    }

    private void processType(Compilation node, List<Annotation> annotations, DocCommentScope scope) {
        TypeInfo typeInfo = node.getDefiningType();
        if (typeInfo != null && TypeInfoEquivalence.isEquivalent(typeInfo, (TypeInfo)scope.getSymbol().getLeft())) {
            this.setCommentIfExists(scope, annotations, node);
        }
    }

    private void setCommentIfExists(final DocCommentScope scope, List<Annotation> annotations, AstNode node) {
        int lineNumber = annotations.isEmpty() ? node.getLoc().getLine() : annotations.stream().map(a -> a.getLoc().getLine()).sorted().findFirst().get().intValue();
        Map.Entry<Integer, HiddenToken> commentEntry = scope.getHiddenTokenMap().lowerEntry(node.getLoc().getStartIndex());
        if (commentEntry == null) {
            return;
        }
        if (this.getEndLine(commentEntry.getValue()) + 1 == lineNumber) {
            commentEntry.getValue().accept(new HiddenToken.Visitor<Void>(){

                @Override
                public Void visit(HiddenTokens.BlockComment hiddenToken) {
                    scope.setComment(hiddenToken.getValue());
                    return null;
                }

                @Override
                public Void visit(HiddenTokens.InlineComment hiddenToken) {
                    return null;
                }
            });
        }
    }
}

