/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.common;

import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfo;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.Version;

public class GenericTypeInfoUtil {
    private static final TypeInfoVisitor<GenericTypeInfo> AS_GENERIC_TYPE = new TypeInfoVisitor.Default<GenericTypeInfo>(){

        @Override
        protected GenericTypeInfo _default(TypeInfo type) {
            throw new UnexpectedCodePathException();
        }

        @Override
        public GenericTypeInfo visit(GenericTypeInfo type) {
            return type;
        }
    };
    private static final TypeInfoVisitor<Boolean> IS_GENERIC_TYPE = new TypeInfoVisitor.Default<Boolean>(){

        @Override
        protected Boolean _default(TypeInfo type) {
            return false;
        }

        @Override
        public Boolean visit(GenericTypeInfo type) {
            return true;
        }
    };
    private static final TypeInfoVisitor<TypeInfo> GET_ROOT_TYPE = new TypeInfoVisitor.Default<TypeInfo>(){

        @Override
        protected TypeInfo _default(TypeInfo type) {
            return type;
        }

        @Override
        public TypeInfo visit(GenericTypeInfo type) {
            return type.getRootUnreifiedType();
        }
    };
    private static final TypeInfoVisitor<Boolean> IS_USER_GENERIC_INTERFACE = new TypeInfoVisitor.Default<Boolean>(){

        @Override
        protected Boolean _default(TypeInfo type) {
            return false;
        }

        @Override
        public Boolean visit(GenericTypeInfo type) {
            return !type.getCodeUnitDetails().isFileBased() && type.getUnitType() == UnitType.INTERFACE;
        }
    };
    private static final TypeInfoVisitor<Boolean> IS_REIFIED_TYPE = new TypeInfoVisitor.Default<Boolean>(){

        @Override
        protected Boolean _default(TypeInfo type) {
            return true;
        }

        @Override
        public Boolean visit(GenericTypeInfo type) {
            for (TypeInfo argumentType : type.getTypeArguments()) {
                if (GenericTypeInfoUtil.isReifiedType(argumentType)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visit(ArgumentTypeInfo type) {
            return false;
        }
    };

    private GenericTypeInfoUtil() {
    }

    public static GenericTypeInfo asGenericType(TypeInfo type) {
        return type.accept(AS_GENERIC_TYPE);
    }

    public static TypeInfo getRootType(TypeInfo type) {
        return type.accept(GET_ROOT_TYPE);
    }

    public static TypeInfo getRootTypeIfNotCollection(TypeInfo type) {
        switch (type.getBasicType()) {
            case LIST: 
            case SET: 
            case MAP: {
                return type;
            }
        }
        return GenericTypeInfoUtil.getRootType(type);
    }

    public static boolean isUserGenericInterface(TypeInfo type) {
        return type.accept(IS_USER_GENERIC_INTERFACE);
    }

    public static boolean isGenericType(TypeInfo type) {
        return type.accept(IS_GENERIC_TYPE);
    }

    public static boolean typeParametersAllowed(boolean hasApexParameterizedTypes, TypeInfo type) {
        CodeUnitDetails codeUnit = type.getCodeUnitDetails();
        return hasApexParameterizedTypes || type.getUnitType() == UnitType.INTERFACE && (codeUnit.isTrusted() || codeUnit.getVersion().isLessThanOrEqual(Version.V178));
    }

    public static boolean isReifiedType(TypeInfo type) {
        return type.accept(IS_REIFIED_TYPE);
    }
}

