/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.lang.LanguageVersion;

public class RuleContext {
    private static final Logger LOG = Logger.getLogger(RuleContext.class.getName());
    private Report report = new Report();
    private File sourceCodeFile;
    private LanguageVersion languageVersion;
    private final ConcurrentMap<String, Object> attributes;
    private boolean ignoreExceptions = true;

    public RuleContext() {
        this.attributes = new ConcurrentHashMap<String, Object>();
    }

    public RuleContext(RuleContext ruleContext) {
        this.attributes = ruleContext.attributes;
        this.report.addListeners(ruleContext.getReport().getListeners());
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public File getSourceCodeFile() {
        return this.sourceCodeFile;
    }

    public void setSourceCodeFile(File sourceCodeFile) {
        this.sourceCodeFile = sourceCodeFile;
    }

    public String getSourceCodeFilename() {
        if (this.sourceCodeFile != null) {
            return this.sourceCodeFile.getName();
        }
        return "";
    }

    @Deprecated
    public void setSourceCodeFilename(String filename) {
        LOG.warning("The method RuleContext::setSourceCodeFilename(String) has been deprecated and will be removed.Setting the filename here has no effect. Use RuleContext::setSourceCodeFile(File) instead.");
    }

    public LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    public void setLanguageVersion(LanguageVersion languageVersion) {
        this.languageVersion = languageVersion;
    }

    @Deprecated
    public boolean setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 'name' cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter 'value' cannot be null.");
        }
        return this.attributes.putIfAbsent(name, value) == null;
    }

    @Deprecated
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Deprecated
    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    public void setIgnoreExceptions(boolean ignoreExceptions) {
        this.ignoreExceptions = ignoreExceptions;
    }

    public boolean isIgnoreExceptions() {
        return this.ignoreExceptions;
    }
}

