/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.cache.CachedRuleMapper;

@Deprecated
@InternalApi
public final class CachedRuleViolation
implements RuleViolation {
    private final CachedRuleMapper mapper;
    private final String description;
    private final String fileName;
    private final String ruleClassName;
    private final String ruleName;
    private final String ruleTargetLanguage;
    private final int beginLine;
    private final int beginColumn;
    private final int endLine;
    private final int endColumn;
    private final String packageName;
    private final String className;
    private final String methodName;
    private final String variableName;

    private CachedRuleViolation(CachedRuleMapper mapper, String description, String fileName, String ruleClassName, String ruleName, String ruleTargetLanguage, int beginLine, int beginColumn, int endLine, int endColumn, String packageName, String className, String methodName, String variableName) {
        this.mapper = mapper;
        this.description = description;
        this.fileName = fileName;
        this.ruleClassName = ruleClassName;
        this.ruleName = ruleName;
        this.ruleTargetLanguage = ruleTargetLanguage;
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
        this.packageName = packageName;
        this.className = className;
        this.methodName = methodName;
        this.variableName = variableName;
    }

    @Override
    public Rule getRule() {
        return this.mapper.getRuleForClass(this.ruleClassName, this.ruleName, this.ruleTargetLanguage);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isSuppressed() {
        return false;
    }

    @Override
    public String getFilename() {
        return this.fileName;
    }

    @Override
    public int getBeginLine() {
        return this.beginLine;
    }

    @Override
    public int getBeginColumn() {
        return this.beginColumn;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getVariableName() {
        return this.variableName;
    }

    static CachedRuleViolation loadFromStream(DataInputStream stream, String fileName, CachedRuleMapper mapper) throws IOException {
        String description = stream.readUTF();
        String ruleClassName = stream.readUTF();
        String ruleName = stream.readUTF();
        String ruleTargetLanguage = stream.readUTF();
        int beginLine = stream.readInt();
        int beginColumn = stream.readInt();
        int endLine = stream.readInt();
        int endColumn = stream.readInt();
        String packageName = stream.readUTF();
        String className = stream.readUTF();
        String methodName = stream.readUTF();
        String variableName = stream.readUTF();
        return new CachedRuleViolation(mapper, description, fileName, ruleClassName, ruleName, ruleTargetLanguage, beginLine, beginColumn, endLine, endColumn, packageName, className, methodName, variableName);
    }

    static void storeToStream(DataOutputStream stream, RuleViolation violation) throws IOException {
        stream.writeUTF(CachedRuleViolation.getValueOrEmpty(violation.getDescription()));
        stream.writeUTF(CachedRuleViolation.getValueOrEmpty(violation.getRule().getRuleClass()));
        stream.writeUTF(CachedRuleViolation.getValueOrEmpty(violation.getRule().getName()));
        stream.writeUTF(CachedRuleViolation.getValueOrEmpty(violation.getRule().getLanguage().getTerseName()));
        stream.writeInt(violation.getBeginLine());
        stream.writeInt(violation.getBeginColumn());
        stream.writeInt(violation.getEndLine());
        stream.writeInt(violation.getEndColumn());
        stream.writeUTF(CachedRuleViolation.getValueOrEmpty(violation.getPackageName()));
        stream.writeUTF(CachedRuleViolation.getValueOrEmpty(violation.getClassName()));
        stream.writeUTF(CachedRuleViolation.getValueOrEmpty(violation.getMethodName()));
        stream.writeUTF(CachedRuleViolation.getValueOrEmpty(violation.getVariableName()));
    }

    private static String getValueOrEmpty(String value) {
        return value == null ? "" : value;
    }
}

