/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import net.sourceforge.pmd.cpd.AnyLanguage;
import net.sourceforge.pmd.cpd.Language;

public final class LanguageFactory {
    public static final String EXTENSION = "extension";
    public static final String BY_EXTENSION = "by_extension";
    private static LanguageFactory instance = new LanguageFactory();
    public static String[] supportedLanguages = LanguageFactory.instance.languages.keySet().toArray(new String[LanguageFactory.instance.languages.size()]);
    private Map<String, Language> languages = new HashMap<String, Language>();

    private LanguageFactory() {
        ArrayList<Language> languagesList = new ArrayList<Language>();
        ServiceLoader<Language> languageLoader = ServiceLoader.load(Language.class, this.getClass().getClassLoader());
        Iterator<Language> iterator = languageLoader.iterator();
        while (true) {
            try {
                while (iterator.hasNext()) {
                    Language language = iterator.next();
                    languagesList.add(language);
                }
            }
            catch (UnsupportedClassVersionError | ServiceConfigurationError e) {
                System.err.println("Ignoring language for PMD: " + e.toString());
                continue;
            }
            break;
        }
        Collections.sort(languagesList, new Comparator<Language>(){

            @Override
            public int compare(Language o1, Language o2) {
                return o1.getTerseName().compareToIgnoreCase(o2.getTerseName());
            }
        });
        this.languages = new LinkedHashMap<String, Language>();
        for (Language language : languagesList) {
            this.languages.put(language.getTerseName().toLowerCase(Locale.ROOT), language);
        }
    }

    public static Language createLanguage(String language) {
        return LanguageFactory.createLanguage(language, new Properties());
    }

    public static Language createLanguage(String language, Properties properties) {
        Language implementation = BY_EXTENSION.equals(language) ? instance.getLanguageByExtension(properties.getProperty(EXTENSION)) : LanguageFactory.instance.languages.get(instance.languageAliases(language).toLowerCase(Locale.ROOT));
        if (implementation == null) {
            implementation = new AnyLanguage(language);
        }
        implementation.setProperties(properties);
        return implementation;
    }

    private String languageAliases(String language) {
        if ("c".equals(language)) {
            return "cpp";
        }
        return language;
    }

    private Language getLanguageByExtension(String extension) {
        Language result = null;
        for (Language language : this.languages.values()) {
            if (!language.getExtensions().contains(extension)) continue;
            result = language;
            break;
        }
        return result;
    }
}

