/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast.internal;

import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTRecordDeclaration;

public final class PrettyPrintingUtil {
    private PrettyPrintingUtil() {
    }

    public static String displaySignature(String methodName, ASTFormalParameters params) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName);
        sb.append('(');
        boolean first = true;
        for (ASTFormalParameter param : params) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(param.getTypeNode().getTypeImage());
            if (!param.isVarargs()) continue;
            sb.append("...");
        }
        sb.append(')');
        return sb.toString();
    }

    public static String displaySignature(ASTMethodOrConstructorDeclaration node) {
        ASTFormalParameters params = (ASTFormalParameters)node.getFirstDescendantOfType(ASTFormalParameters.class);
        String name = node instanceof ASTMethodDeclaration ? ((ASTMethodDeclaration)node).getName() : node.getImage();
        return PrettyPrintingUtil.displaySignature(name, params);
    }

    public static String kindName(ASTAnyTypeDeclaration decl) {
        if (decl instanceof ASTClassOrInterfaceDeclaration && ((ASTClassOrInterfaceDeclaration)decl).isInterface()) {
            return "interface";
        }
        if (decl instanceof ASTAnnotationTypeDeclaration) {
            return "annotation";
        }
        if (decl instanceof ASTEnumDeclaration) {
            return "enum";
        }
        if (decl instanceof ASTRecordDeclaration) {
            return "record";
        }
        return "class";
    }

    public static String prettyImport(ASTImportDeclaration importDecl) {
        String name = importDecl.getImportedName();
        if (importDecl.isImportOnDemand()) {
            return name + ".*";
        }
        return name;
    }
}

