/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.rule.codestyle;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.plsql.ast.ASTArgument;
import net.sourceforge.pmd.lang.plsql.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.plsql.ast.ASTBulkCollectIntoClause;
import net.sourceforge.pmd.lang.plsql.ast.ASTDatatype;
import net.sourceforge.pmd.lang.plsql.ast.ASTDeclarativeSection;
import net.sourceforge.pmd.lang.plsql.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.plsql.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.plsql.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.plsql.ast.ASTFromClause;
import net.sourceforge.pmd.lang.plsql.ast.ASTInput;
import net.sourceforge.pmd.lang.plsql.ast.ASTJoinClause;
import net.sourceforge.pmd.lang.plsql.ast.ASTSelectList;
import net.sourceforge.pmd.lang.plsql.ast.ASTSubqueryOperation;
import net.sourceforge.pmd.lang.plsql.ast.ASTUnqualifiedID;
import net.sourceforge.pmd.lang.plsql.ast.ASTVariableOrConstantDeclarator;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.rule.AbstractPLSQLRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class CodeFormatRule
extends AbstractPLSQLRule {
    private static final PropertyDescriptor<Integer> INDENTATION_PROPERTY = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"indentation").desc("Indentation to be used for blocks")).defaultValue((Object)2)).require(NumericConstraints.inRange((Number)0, (Number)32))).build();
    private int indentation = (Integer)INDENTATION_PROPERTY.defaultValue();

    public CodeFormatRule() {
        this.definePropertyDescriptor(INDENTATION_PROPERTY);
    }

    @Override
    public Object visit(ASTInput node, Object data) {
        this.indentation = (Integer)this.getProperty(INDENTATION_PROPERTY);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTSelectList node, Object data) {
        Node parent = node.getParent();
        this.checkEachChildOnNextLine(data, node, parent.getBeginLine(), parent.getBeginColumn() + 7);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTBulkCollectIntoClause node, Object data) {
        Node parent = node.getParent();
        this.checkIndentation(data, node, parent.getBeginColumn() + this.indentation, "BULK COLLECT INTO");
        this.checkEachChildOnNextLine(data, node, node.getBeginLine(), parent.getBeginColumn() + 7);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFromClause node, Object data) {
        this.checkIndentation(data, node, ((PLSQLNode)node.getParent()).getBeginColumn() + this.indentation, "FROM");
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTJoinClause node, Object data) {
        Node tableReference = node.getChild(0);
        int lineNumber = tableReference.getBeginLine();
        for (int i = 1; i < node.getNumChildren(); ++i) {
            List conditions;
            Node child = node.getChild(i);
            if (child.getBeginLine() != ++lineNumber) {
                this.addViolationWithMessage(data, child, child.getXPathNodeName() + " should be on line " + lineNumber);
            }
            if ((conditions = child.findDescendantsOfType(ASTEqualityExpression.class)).size() == 1) {
                ASTEqualityExpression singleCondition = (ASTEqualityExpression)conditions.get(0);
                if (singleCondition.getBeginLine() == lineNumber) continue;
                this.addViolationWithMessage(data, child, "Join condition \"" + singleCondition.getImage() + "\" should be on line " + lineNumber);
                continue;
            }
            for (ASTEqualityExpression singleCondition : conditions) {
                if (singleCondition.getBeginLine() == ++lineNumber) continue;
                this.addViolationWithMessage(data, child, "Join condition \"" + singleCondition.getImage() + "\" should be on line " + lineNumber);
            }
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTSubqueryOperation node, Object data) {
        int thisIndex = node.getIndexInParent();
        PLSQLNode prevSibling = ((PLSQLNode)node.getParent()).getChild(thisIndex - 1);
        this.checkIndentation(data, node, prevSibling.getBeginColumn(), node.getImage());
        if (node.getBeginLine() != prevSibling.getEndLine() + 1) {
            this.addViolationWithMessage(data, node, node.getImage() + " should be on line " + (prevSibling.getEndLine() + 1));
        }
        return super.visit(node, data);
    }

    private int checkEachChildOnNextLine(Object data, Node parent, int firstLine, int indentation) {
        int currentLine = firstLine;
        for (int i = 0; i < parent.getNumChildren(); ++i) {
            Node child = parent.getChild(i);
            String image = child.getImage();
            if (image == null && child.getNumChildren() > 0) {
                image = child.getChild(0).getImage();
            }
            if (child.getBeginLine() != currentLine) {
                this.addViolationWithMessage(data, child, image + " should be on line " + currentLine);
            } else if (i > 0 && child.getBeginColumn() != indentation) {
                this.addViolationWithMessage(data, child, image + " should begin at column " + indentation);
            }
            ++currentLine;
        }
        return currentLine;
    }

    private void checkLineAndIndentation(Object data, Node node, int line, int indentation, String name) {
        if (node.getBeginLine() != line) {
            this.addViolationWithMessage(data, node, name + " should be on line " + line);
        } else if (node.getBeginColumn() != indentation) {
            this.addViolationWithMessage(data, node, name + " should begin at column " + indentation);
        }
    }

    private void checkIndentation(Object data, Node node, int indentation, String name) {
        if (node.getBeginColumn() != indentation) {
            this.addViolationWithMessage(data, node, name + " should begin at column " + indentation);
        }
    }

    @Override
    public Object visit(ASTFormalParameters node, Object data) {
        int parameterIndentation = ((PLSQLNode)node.getParent()).getBeginColumn() + this.indentation;
        this.checkEachChildOnNextLine(data, node, node.getBeginLine() + 1, parameterIndentation);
        List parameters = node.findChildrenOfType(ASTFormalParameter.class);
        if (parameters.size() > 1) {
            ASTDatatype first = (ASTDatatype)((ASTFormalParameter)parameters.get(0)).getFirstChildOfType(ASTDatatype.class);
            for (int i = 1; first != null && i < parameters.size(); ++i) {
                ASTDatatype nextType = (ASTDatatype)((ASTFormalParameter)parameters.get(i)).getFirstChildOfType(ASTDatatype.class);
                if (nextType == null) continue;
                this.checkIndentation(data, nextType, first.getBeginColumn(), "Type " + nextType.getImage());
            }
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTDeclarativeSection node, Object data) {
        ASTDatatype datatype;
        int variableIndentation = node.getNthParent(2).getBeginColumn() + 2 * this.indentation;
        int line = node.getBeginLine();
        List variables = node.findDescendantsOfType(ASTVariableOrConstantDeclarator.class);
        int datatypeIndentation = variableIndentation;
        if (!variables.isEmpty() && (datatype = (ASTDatatype)((ASTVariableOrConstantDeclarator)variables.get(0)).getFirstChildOfType(ASTDatatype.class)) != null) {
            datatypeIndentation = datatype.getBeginColumn();
        }
        for (ASTVariableOrConstantDeclarator variable : variables) {
            this.checkLineAndIndentation(data, variable, line, variableIndentation, variable.getImage());
            ASTDatatype datatype2 = (ASTDatatype)variable.getFirstChildOfType(ASTDatatype.class);
            if (datatype2 != null) {
                this.checkIndentation(data, datatype2, datatypeIndentation, "Type " + datatype2.getImage());
            }
            ++line;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTArgumentList node, Object data) {
        List arguments = node.findChildrenOfType(ASTArgument.class);
        if (node.getEndColumn() > 120) {
            this.addViolationWithMessage(data, node, "Line is too long, please split parameters on separate lines");
            return super.visit(node, data);
        }
        if (arguments.size() > 3) {
            if (this.usesSimpleParameters(arguments)) {
                this.addViolationWithMessage(data, node, "Procedure call with more than three parameters should use named parameters.");
            }
            int line = node.getBeginLine();
            int indentation = node.getBeginColumn();
            int longestParameterEndColumn = 0;
            for (Object argument : arguments) {
                this.checkLineAndIndentation(data, (Node)argument, line, indentation, "Parameter " + argument.getImage());
                ++line;
                if (!(argument.getChild(0) instanceof ASTUnqualifiedID) || ((PLSQLNode)argument.getChild(0)).getEndColumn() <= longestParameterEndColumn) continue;
                longestParameterEndColumn = ((PLSQLNode)argument.getChild(0)).getEndColumn();
            }
            int expectedBeginColumn = longestParameterEndColumn + 3 + "=> ".length();
            if (!arguments.isEmpty() && ((ASTArgument)arguments.get(0)).getNumChildren() == 2 && ((PLSQLNode)((ASTArgument)arguments.get(0)).getChild(1)).getBeginColumn() > expectedBeginColumn) {
                expectedBeginColumn = ((PLSQLNode)((ASTArgument)arguments.get(0)).getChild(1)).getBeginColumn();
            }
            for (ASTArgument argument : arguments) {
                if (argument.getNumChildren() != 2 || !(argument.getChild(0) instanceof ASTUnqualifiedID)) continue;
                Node expr = argument.getChild(1);
                this.checkIndentation(data, expr, expectedBeginColumn, expr.getImage());
            }
            Node primaryExpression = node.getNthParent(3);
            if (primaryExpression.getEndLine() != node.getEndLine() + 1) {
                this.addViolationWithMessage(data, primaryExpression, "Closing paranthesis should be on a new line.");
            }
        }
        return super.visit(node, data);
    }

    private boolean usesSimpleParameters(List<ASTArgument> arguments) {
        for (ASTArgument argument : arguments) {
            if (argument.getNumChildren() != 1) continue;
            return true;
        }
        return false;
    }
}

