/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetLoadException;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSetReferenceId;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.ResourceLoader;

public final class RuleSetLoader {
    private static final Logger LOG = Logger.getLogger(RuleSetLoader.class.getName());
    private ResourceLoader resourceLoader = new ResourceLoader(RuleSetLoader.class.getClassLoader());
    private RulePriority minimumPriority = RulePriority.LOW;
    private boolean warnDeprecated = true;
    private boolean enableCompatibility = true;
    private boolean includeDeprecatedRuleReferences = false;

    public RuleSetLoader loadResourcesWith(ClassLoader classLoader) {
        this.resourceLoader = new ResourceLoader(classLoader);
        return this;
    }

    RuleSetLoader loadResourcesWith(ResourceLoader loader) {
        this.resourceLoader = loader;
        return this;
    }

    public RuleSetLoader filterAbovePriority(RulePriority minimumPriority) {
        this.minimumPriority = minimumPriority;
        return this;
    }

    public RuleSetLoader warnDeprecated(boolean warn) {
        this.warnDeprecated = warn;
        return this;
    }

    public RuleSetLoader enableCompatibility(boolean enable) {
        this.enableCompatibility = enable;
        return this;
    }

    public RuleSetLoader includeDeprecatedRuleReferences(boolean enable) {
        this.includeDeprecatedRuleReferences = enable;
        return this;
    }

    @Deprecated
    public RuleSetFactory toFactory() {
        return new RuleSetFactory(this.resourceLoader, this.minimumPriority, this.warnDeprecated, this.enableCompatibility, this.includeDeprecatedRuleReferences);
    }

    public RuleSet loadFromResource(String rulesetPath) {
        return this.loadFromResource(new RuleSetReferenceId(rulesetPath));
    }

    public List<RuleSet> loadFromResources(Collection<String> paths) {
        ArrayList<RuleSet> ruleSets = new ArrayList<RuleSet>(paths.size());
        for (String path : paths) {
            ruleSets.add(this.loadFromResource(path));
        }
        return ruleSets;
    }

    public List<RuleSet> loadFromResources(String first, String ... rest) {
        return this.loadFromResources(CollectionUtil.listOf(first, rest));
    }

    RuleSet loadFromResource(RuleSetReferenceId ruleSetReferenceId) {
        try {
            return this.toFactory().createRuleSet(ruleSetReferenceId);
        }
        catch (Exception e) {
            throw new RuleSetLoadException("Cannot parse " + ruleSetReferenceId, e);
        }
    }

    public static RuleSetLoader fromPmdConfig(PMDConfiguration configuration) {
        return new RuleSetLoader().filterAbovePriority(configuration.getMinimumPriority()).enableCompatibility(configuration.isRuleSetFactoryCompatibilityEnabled());
    }

    public List<RuleSet> getStandardRuleSets() {
        ArrayList<RuleSetReferenceId> ruleSetReferenceIds = new ArrayList<RuleSetReferenceId>();
        for (Language language : LanguageRegistry.findWithRuleSupport()) {
            Properties props = new Properties();
            String rulesetsProperties = "category/" + language.getTerseName() + "/categories.properties";
            try {
                InputStream inputStream = this.resourceLoader.loadClassPathResourceAsStreamOrThrow(rulesetsProperties);
                try {
                    props.load(inputStream);
                    String rulesetFilenames = props.getProperty("rulesets.filenames");
                    if (rulesetFilenames == null) continue;
                    ruleSetReferenceIds.addAll(RuleSetReferenceId.parse(rulesetFilenames));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (RuleSetNotFoundException e) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("The language " + language.getTerseName() + " provides no " + rulesetsProperties + ".");
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Couldn't read " + rulesetsProperties + "; please ensure that the directory is on the classpath. The current classpath is: " + System.getProperty("java.class.path"));
                LOG.fine(ioe.toString());
            }
        }
        ArrayList<RuleSet> ruleSets = new ArrayList<RuleSet>();
        for (RuleSetReferenceId id : ruleSetReferenceIds) {
            ruleSets.add(this.loadFromResource(id));
        }
        return ruleSets;
    }
}

