/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.datasource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.internal.util.ShortFilenameUtil;
import net.sourceforge.pmd.util.datasource.internal.AbstractDataSource;

public class FileDataSource
extends AbstractDataSource {
    private final File file;

    public FileDataSource(File file) {
        this.file = file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.file.toPath(), new OpenOption[0]);
    }

    @Override
    public String getNiceFileName(boolean shortNames, String inputPaths) {
        return this.glomName(shortNames, inputPaths, this.file);
    }

    private String glomName(boolean shortNames, String inputPaths, File file) {
        if (shortNames) {
            if (inputPaths != null) {
                List<String> inputPathPrefixes = Arrays.asList(inputPaths.split(","));
                String absoluteFilePath = file.getAbsolutePath();
                return ShortFilenameUtil.determineFileName(inputPathPrefixes, absoluteFilePath);
            }
            return file.getName();
        }
        try {
            return file.getCanonicalFile().getAbsolutePath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    public String toString() {
        return FileDataSource.class.getSimpleName() + '[' + this.file.getPath() + ']';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileDataSource other = (FileDataSource)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }
}

