/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.codeActions;

import apex.jorje.data.Identifiers;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.TypeRefBuilder;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.ast.VariableDecl;
import apex.jorje.data.ast.VariableDecls;
import apex.jorje.lsp.impl.codeActions.ExtractHandler;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.utils.CodeActionsUtil;
import apex.jorje.lsp.impl.utils.ExtractUtil;
import apex.jorje.lsp.impl.utils.Locations;
import apex.jorje.lsp.impl.visitors.CodeActionScope;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.services.printers.PrintContexts;
import apex.jorje.services.printers.PrinterUtil;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.antlr.runtime.RecognitionException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractConstantHandler
implements ExtractHandler {
    private static final Logger logger = LoggerFactory.getLogger(ExtractConstantHandler.class);
    private final Expression node;
    private final CodeActionScope scope;
    private static final String EXTRACT_CONSTANT_KEY = "extract.constant";
    private static final String CONSTANT_NAME = "v1";
    private static final List<Modifier> NEW_STATEMENT_MODIFIERS = ImmutableList.of(Modifier._PrivateModifier(Locations.NONE), Modifier._StaticModifier(Locations.NONE), Modifier._FinalModifier(Locations.NONE));
    private static final List<Modifier> INNER_CLASS_STATEMENT_MODIFIERS = ImmutableList.of(Modifier._PrivateModifier(Locations.NONE), Modifier._FinalModifier(Locations.NONE));

    public ExtractConstantHandler(Expression node, CodeActionScope scope) {
        this.node = node;
        this.scope = scope;
    }

    @Override
    public Optional<CodeAction> getCodeAction() {
        if (!ExtractUtil.canExtract(this.node).booleanValue() || !ExtractUtil.canExtractConstant(this.node).booleanValue()) {
            return Optional.empty();
        }
        try {
            return CodeActionsUtil.buildCodeAction(EXTRACT_CONSTANT_KEY, "refactor.extract.constant", this.node, ImmutableList.of(this.getNewStatementTextEdit(), this.getModifiedExpressionTextEdit()));
        }
        catch (BadLocationException | RecognitionException e) {
            logger.error("Exception thrown while getting extract constant code action", e);
            return Optional.empty();
        }
    }

    private TextEdit getNewStatementTextEdit() throws RecognitionException {
        Stmnt.VariableDeclStmnt declarationStatement = this.getNewVariableDeclaration();
        Location parentClassLoc = this.node.getDefiningType().getCodeUnitDetails().getLoc();
        String declarationStatementText = this.getNewExpressionStatementIndent(this.scope.getSource(), parentClassLoc) + PrinterUtil.get().getFactory().stmntPrinter().print(declarationStatement, PrintContexts.standard()) + "\n";
        return new TextEdit(new Range(new Position(parentClassLoc.getLine(), 0), new Position(parentClassLoc.getLine(), 0)), declarationStatementText);
    }

    private Stmnt.VariableDeclStmnt getNewVariableDeclaration() throws RecognitionException {
        Expr baseExpression = ExtractUtil.parse(this.scope.getSource().substring(this.scope.getNodeStartOffset(), this.scope.getNodeEndOffset())).expression();
        VariableDecl variableDecl = VariableDecl._VariableDecl(Identifiers.newIdentifier(CONSTANT_NAME), Optional.of(baseExpression));
        return (Stmnt.VariableDeclStmnt)Stmnt._VariableDeclStmnt(VariableDecls._VariableDecls(this.getModifiers(), TypeRefBuilder.type(this.node.getType().getApexName()), ImmutableList.of(variableDecl)));
    }

    private String getNewExpressionStatementIndent(String source, Location parentLoc) {
        String indexing = "";
        int parentLine = parentLoc.getLine() - 1;
        if (StringUtils.isNotBlank((CharSequence)source)) {
            String[] textLines = source.split("[\\n|\\r]");
            String lineText = textLines[parentLine];
            String[] parts = lineText.split("[A-Za-z]", 2);
            indexing = parts[0] + "\t";
        }
        return indexing;
    }

    private TextEdit getModifiedExpressionTextEdit() throws BadLocationException {
        return new TextEdit(Locations.Ranges.from(this.scope.getDocument(), this.scope.getNodeStartOffset(), this.scope.getNodeEndOffset(), this.node.getLoc().getLine(), this.scope.getNodeColumn()), CONSTANT_NAME);
    }

    private List<Modifier> getModifiers() {
        return this.scope.getNode().map(astNode -> TypeInfoUtil.isInnerType(astNode.getDefiningType())).orElse(false) != false ? INNER_CLASS_STATEMENT_MODIFIERS : NEW_STATEMENT_MODIFIERS;
    }
}

