/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.converter;

import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.converter.FieldConverter;
import apex.jorje.lsp.impl.index.converter.MethodConverter;
import apex.jorje.lsp.impl.index.converter.ParameterConverter;
import apex.jorje.lsp.impl.index.converter.TypeIdConverter;
import apex.jorje.lsp.impl.index.node.ApexResourceFile;
import apex.jorje.lsp.impl.index.node.ApexType;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.semantic.ast.modifier.Modifier;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypeInfoConverter {
    private static final Logger logger = LoggerFactory.getLogger(TypeInfoConverter.class);
    private final ApexResourceFile resourceFile;
    private final TypeIdConverter typeIdConverter;
    private final ParameterConverter parameterConverter;
    private final FieldConverter fieldConverter;
    private final MethodConverter methodConverter;
    private final ApexIndex apexIndex;

    @Inject
    TypeInfoConverter(ApexIndex index, @Assisted ApexResourceFile resourceFile) {
        this.resourceFile = resourceFile;
        this.typeIdConverter = new TypeIdConverter(index);
        this.parameterConverter = new ParameterConverter(this.typeIdConverter);
        this.fieldConverter = new FieldConverter(this.typeIdConverter);
        this.methodConverter = new MethodConverter(this.typeIdConverter, this.parameterConverter);
        this.apexIndex = index;
    }

    static String stringifyModifiers(List<Modifier> modifiers) {
        return modifiers.stream().map(Modifier::toString).map(String::toLowerCase).collect(Collectors.joining(" "));
    }

    private Nd getNd() {
        return this.resourceFile.getNd();
    }

    public ApexType addType(TypeInfo typeInfo) {
        return this.addType(typeInfo, false);
    }

    public ApexType addType(TypeInfo typeInfo, boolean isSObject) {
        logger.debug("Adding typeinfo of " + typeInfo);
        ApexTypeId typeId = this.typeIdConverter.getOrCreateTypeId(typeInfo);
        ApexType type = this.getOrCreateType(typeId);
        type.setTypeId(typeId);
        type.setIsSObject(isSObject);
        if (typeInfo.getEnclosingType() != null) {
            typeId.setEnclosingType(this.typeIdConverter.getOrCreateTypeId(typeInfo.getEnclosingType()));
        }
        List<Modifier> modifiers = typeInfo.getModifiers().copy().getModifiers();
        type.setModifiers(TypeInfoConverter.stringifyModifiers(modifiers));
        type.setUnitType(typeInfo.getUnitType().name());
        for (MethodInfo methodInfo : typeInfo.methods().all()) {
            this.methodConverter.addMethod(methodInfo, type);
        }
        for (FieldInfo fieldInfo : typeInfo.fields().all()) {
            this.fieldConverter.addField(fieldInfo, type, isSObject);
        }
        ParentTable parentTable = typeInfo.parents();
        TypeInfo superType = parentTable.superType();
        if (superType != null) {
            ApexTypeId parentTypeId = this.typeIdConverter.getOrCreateTypeId(superType);
            typeId.setParent(parentTypeId);
        }
        List<TypeInfo> interfaces = parentTable.immediateInterfaces();
        for (TypeInfo interfaceInfo : interfaces) {
            ApexTypeId interfaceTypeId = this.typeIdConverter.getOrCreateTypeId(interfaceInfo);
            typeId.addInterface(this.resourceFile, interfaceTypeId);
        }
        return type;
    }

    private ApexType getOrCreateType(ApexTypeId typeId) {
        ApexType type = typeId.getType();
        if (type == null) {
            type = new ApexType(this.getNd(), this.resourceFile);
        } else if (!type.getFile().getFilename().getString().equalsIgnoreCase(this.resourceFile.getFilename().getString())) {
            type = new ApexType(this.getNd(), this.resourceFile);
        }
        return type;
    }
}

