/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.node;

import apex.jorje.data.Location;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexResourceFile;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NdNode;
import org.eclipse.jdt.internal.core.nd.db.IString;
import org.eclipse.jdt.internal.core.nd.field.FieldInt;
import org.eclipse.jdt.internal.core.nd.field.FieldManyToOne;
import org.eclipse.jdt.internal.core.nd.field.FieldSearchKey;
import org.eclipse.jdt.internal.core.nd.field.StructDef;

public class ApexReference
extends NdNode
implements Location {
    public static final StructDef<ApexReference> type = StructDef.create(ApexReference.class, (StructDef)NdNode.type);
    public static final FieldSearchKey<ApexIndex> SYMBOL_NAME = FieldSearchKey.create(type, ApexIndex.REFERENCES_BY_TARGET_SYMBOL);
    static final FieldManyToOne<ApexResourceFile> FILE = FieldManyToOne.createOwner(type, ApexResourceFile.REFERENCES);
    static final FieldInt LINE = type.addInt();
    static final FieldInt COLUMN = type.addInt();
    static final FieldInt START_INDEX = type.addInt();
    static final FieldInt END_INDEX = type.addInt();

    public ApexReference(Nd nd, long address) {
        super(nd, address);
    }

    public ApexReference(Nd nd, ApexResourceFile resourceFile, String symbolName, int line, int column, int startIndex, int endIndex) {
        super(nd);
        FILE.put(nd, this.address, (NdNode)resourceFile);
        SYMBOL_NAME.put(nd, this.address, symbolName);
        LINE.put(nd, this.address, line);
        START_INDEX.put(nd, this.address, startIndex);
        END_INDEX.put(nd, this.address, endIndex);
        COLUMN.put(nd, this.address, column);
    }

    public ApexReference(Nd nd, ApexResourceFile resourceFile, String symbolName, Location location) {
        this(nd, resourceFile, symbolName, location.getLine(), location.getColumn(), location.getStartIndex(), location.getEndIndex());
    }

    public IString getSymbolName() {
        return SYMBOL_NAME.get(this.getNd(), this.address);
    }

    public IString getDocUri() {
        ApexResourceFile doc = (ApexResourceFile)FILE.get(this.getNd(), this.address);
        return doc.getFilename();
    }

    @Override
    public int getLine() {
        return LINE.get(this.getNd(), this.address);
    }

    @Override
    public int getColumn() {
        return COLUMN.get(this.getNd(), this.address);
    }

    @Override
    public int getStartIndex() {
        return START_INDEX.get(this.getNd(), this.address);
    }

    @Override
    public int getEndIndex() {
        return END_INDEX.get(this.getNd(), this.address);
    }

    static {
        type.done();
    }
}

