/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.EmptyReferenceExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.MethodCallInterceptor;
import apex.jorje.semantic.ast.expression.ReferenceContext;
import apex.jorje.semantic.ast.expression.SoqlExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.BooleanScope;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.bcl.DatabaseEmitMethods;
import apex.jorje.semantic.bcl.ExceptionMethods;
import apex.jorje.semantic.bcl.ListEmitMethods;
import apex.jorje.semantic.bcl.ObjectEmitMethods;
import apex.jorje.semantic.bcl.SObjectEmitMethods;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.common.iterator.EqualPairIterator;
import apex.jorje.semantic.common.iterator.Pair;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.GenericCalledMethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodUtil;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.ExceptionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import java.util.List;
import java.util.Objects;

final class MethodCallInterceptors {
    private static final AstVisitor<BooleanScope> IS_PATH_EXPRESSION = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(VariableExpression node, BooleanScope scope) {
            scope.setValue(!EmptyReferenceExpression.isEmptyReference(node.getReferenceContext()));
        }
    };
    private static final AstVisitor<NoopScope> MARK_EMIT_LAST_AS_FALSE = new AstVisitor<NoopScope>(){

        @Override
        public void visitEnd(VariableExpression node, NoopScope scope) {
            node.getContext().emitLast = false;
            MethodCallInterceptors.markEmitLastAsFalse(node.getReferenceContext());
        }
    };

    private MethodCallInterceptors() {
    }

    private static boolean isPathExpression(Expression expression) {
        return BooleanScope.evaluate(expression, IS_PATH_EXPRESSION, false);
    }

    private static void markEmitLastAsFalse(ReferenceContext reference) {
        for (VariableVisitor.Context context : reference.getContexts()) {
            context.emitLast = false;
        }
        reference.getDottedExpression().traverse(MARK_EMIT_LAST_AS_FALSE, NoopScope.get());
    }

    static class IsUserGenericInterface
    implements MethodCallInterceptor {
        IsUserGenericInterface() {
        }

        @Override
        public boolean shouldIntercept(MethodCallExpression methodCall) {
            return GenericTypeInfoUtil.isUserGenericInterface(methodCall.getMethod().get().getDefiningType());
        }

        @Override
        public void intercept(MethodCallExpression methodCall, Emitter emitter) {
            MethodInfo method = methodCall.getMethod().get();
            GenericCalledMethodInfo genericMethod = new GenericCalledMethodInfo(method);
            methodCall.emitReferenceExpression(emitter);
            MethodInfo proxy = emitter.getProxyMethodTable().get(methodCall.getLoc(), methodCall.getDefiningType(), methodCall.getReferenceType(), genericMethod);
            if (methodCall.getReferenceContext().getContext() == IdentifierContext.NONE && !method.getModifiers().has(ModifierTypeInfos.STATIC)) {
                emitter.emitVar(methodCall.getLoc(), 25, 0);
            }
            methodCall.emitParameters(emitter);
            emitter.emit(methodCall.getLoc(), proxy != null ? proxy.getAsmMethod() : genericMethod.getAsmMethod());
            if (MethodUtil.returnsNonVoid(genericMethod)) {
                methodCall.convertReturnType(emitter);
            }
            methodCall.convertReturnTypeIfNecessary(emitter);
        }
    }

    static class IsFuture
    implements MethodCallInterceptor {
        IsFuture() {
        }

        private void emitParameterValues(MethodCallExpression methodCall, Emitter emitter) {
            MethodInfo method = methodCall.getMethod().get();
            emitter.emitType(methodCall.getLoc(), 187, ReifiedTypeInfos.OBJECT_LIST);
            emitter.emit(methodCall.getLoc(), 89);
            emitter.emit(methodCall.getLoc(), ObjectEmitMethods.constructor(ReifiedTypeInfos.OBJECT_LIST));
            for (Pair<Expression, TypeInfo> pair : EqualPairIterator.iterable(methodCall.getInputParameters(), method.getEmitSignature().getParameterTypes())) {
                emitter.emit(methodCall.getLoc(), 89);
                pair.getLeft().emit(emitter);
                TypeConversion.emit(methodCall.getLoc(), emitter, pair.getLeft().getType(), pair.getRight());
                emitter.emit(methodCall.getLoc(), ListEmitMethods.addNoReturn(ReifiedTypeInfos.OBJECT_LIST));
            }
        }

        private void emitParameterTypes(MethodCallExpression methodCall, Emitter emitter) {
            MethodInfo method = methodCall.getMethod().get();
            emitter.emitType(methodCall.getLoc(), 187, ReifiedTypeInfos.OBJECT_LIST);
            emitter.emit(methodCall.getLoc(), 89);
            emitter.emit(methodCall.getLoc(), ObjectEmitMethods.constructor(ReifiedTypeInfos.OBJECT_LIST));
            for (Parameter parameter : method.getParameters()) {
                emitter.emit(methodCall.getLoc(), 89);
                emitter.push(methodCall.getLoc(), parameter.getType().getApexName());
                emitter.emit(methodCall.getLoc(), ListEmitMethods.addNoReturn(ReifiedTypeInfos.OBJECT_LIST));
            }
        }

        @Override
        public boolean shouldIntercept(MethodCallExpression methodCall) {
            MethodInfo method = methodCall.getMethod().get();
            return method.getModifiers().has(AnnotationTypeInfos.FUTURE);
        }

        @Override
        public void intercept(MethodCallExpression methodCall, Emitter emitter) {
            MethodInfo method = methodCall.getMethod().get();
            TypeInfo definingType = method.getDefiningType();
            UnitType unitType = definingType.getUnitType();
            if (unitType == UnitType.ANONYMOUS || unitType == UnitType.TRIGGER) {
                emitter.push(methodCall.getLoc(), "No enclosing class for method: " + method.getName());
                emitter.emit(methodCall.getLoc(), SystemEmitMethods.THROW_ASYNC_EXCEPTION);
                return;
            }
            emitter.push(methodCall.getLoc(), definingType.getBytecodeName());
            emitter.push(methodCall.getLoc(), method.getName());
            AnnotationParameter limit = method.getModifiers().get(AnnotationTypeInfos.FUTURE).getParameter("limits");
            emitter.push(methodCall.getLoc(), limit == null ? null : limit.getStringValue());
            AnnotationParameter delay = method.getModifiers().get(AnnotationTypeInfos.FUTURE).getParameter("delay");
            emitter.push(methodCall.getLoc(), delay == null ? 0 : delay.getIntegerValue());
            emitter.box(TypeInfos.INTEGER);
            this.emitParameterValues(methodCall, emitter);
            this.emitParameterTypes(methodCall, emitter);
            emitter.emit(methodCall.getLoc(), SystemEmitMethods.SCHEDULE_FUTURE);
        }
    }

    static class GetQueryLocator
    implements MethodCallInterceptor {
        GetQueryLocator() {
        }

        @Override
        public boolean shouldIntercept(MethodCallExpression methodCall) {
            MethodInfo method = methodCall.getMethod().get();
            return Objects.equals(method.getName(), "getQueryLocator") && method.getParameters().size() == 1 && TypeInfoEquivalence.isEquivalent(method.getDefiningType(), InternalTypeInfos.DATABASE) && ExpressionUtil.isSoqlExpression(methodCall.getInputParameters().get(0));
        }

        @Override
        public void intercept(MethodCallExpression methodCall, Emitter emitter) {
            List<Expression> inputParameters = methodCall.getInputParameters();
            MethodInfo method = methodCall.getMethod().get();
            SoqlExpression soqlExpression = ExpressionUtil.getSoqlExpression(inputParameters.get(0));
            methodCall.emitReferenceExpression(emitter);
            soqlExpression.getBindExpression().emit(emitter);
            method.getProfilingType().emit(emitter, methodCall);
            emitter.emit(methodCall.getLoc(), DatabaseEmitMethods.GET_QUERY_LOCATOR_WITH_STRING_MAP);
        }
    }

    static class AddError
    implements MethodCallInterceptor {
        AddError() {
        }

        @Override
        public boolean shouldIntercept(MethodCallExpression methodCall) {
            MethodInfo method = methodCall.getMethod().get();
            return method.getGenerated() == Generated.BUILT_IN && Objects.equals(method.getName(), "addError") && !this.isAddErrorExplicitFieldParam(methodCall);
        }

        @Override
        public void intercept(MethodCallExpression methodCall, Emitter emitter) {
            ReferenceContext reference = methodCall.getReferenceContext();
            Location loc = methodCall.getLoc();
            Expression dottedExpression = reference.getDottedExpression();
            if (this.isReferenceDottedMethodOrSingleFieldOrSobject(reference, dottedExpression, methodCall)) {
                methodCall.emitReferenceExpression(emitter);
                emitter.emit(loc, 1);
            } else {
                MethodCallInterceptors.markEmitLastAsFalse(reference);
                methodCall.emitReferenceExpression(emitter);
            }
            List<Expression> inputParameters = methodCall.getInputParameters();
            inputParameters.get(0).emit(emitter);
            TypeInfo firstParameterType = inputParameters.get(0).getType();
            if (ExceptionTypeInfoUtil.isException(emitter.getType(), firstParameterType)) {
                emitter.emit(loc, ExceptionMethods.getMessage(firstParameterType));
            } else {
                TypeConversion.emit(loc, emitter, firstParameterType, TypeInfos.STRING);
            }
            if (inputParameters.size() == 2) {
                inputParameters.get(1).emit(emitter);
                emitter.emit(loc, SObjectEmitMethods.ADD_ERROR_TWO);
            } else {
                emitter.emit(loc, SObjectEmitMethods.ADD_ERROR_ONE);
            }
        }

        private boolean isAddErrorExplicitFieldParam(MethodCallExpression method) {
            ReferenceContext reference = method.getReferenceContext();
            Expression dottedExpression = reference.getDottedExpression();
            List<Expression> inputParameters = method.getInputParameters();
            TypeInfo firstParameterType = inputParameters.get(0).getType();
            if (inputParameters.size() > 1 && this.isReferenceDottedMethodOrSingleFieldOrSobject(reference, dottedExpression, method)) {
                boolean isSobjectFieldStringMethod;
                TypeInfo secondParameterType = inputParameters.get(1).getType();
                boolean isStringStringMethod = TypeInfoEquivalence.isEquivalent(firstParameterType, TypeInfos.STRING) && TypeInfoEquivalence.isEquivalent(secondParameterType, TypeInfos.STRING);
                boolean bl = isSobjectFieldStringMethod = TypeInfoEquivalence.isEquivalent(firstParameterType, InternalTypeInfos.SCHEMA_SOBJECT_FIELD) && TypeInfoEquivalence.isEquivalent(secondParameterType, TypeInfos.STRING);
                if (isStringStringMethod || isSobjectFieldStringMethod) {
                    return true;
                }
            }
            return false;
        }

        private boolean isReferenceDottedMethodOrSingleFieldOrSobject(ReferenceContext reference, Expression dottedExpression, MethodCallExpression method) {
            return reference.getVariables().isEmpty() && !MethodCallInterceptors.isPathExpression(dottedExpression) || method.getReferenceType().getBasicType() == BasicType.SOBJECT;
        }
    }
}

