/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.common.collect.MoreIterables;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.statement.IfBlockStatement;
import apex.jorje.semantic.ast.statement.IfElseBlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.StatementExecuted;
import apex.jorje.semantic.ast.statement.StatementUtil;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.BooleanScope;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.symbol.member.method.MethodUtil;
import apex.jorje.semantic.symbol.member.variable.LocalVariableScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class BlockStatement
extends Statement {
    private static final AstVisitor<BooleanScope> INSIDE_IF_ELSE_BLOCK = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(IfBlockStatement node, BooleanScope scope) {
            scope.setValue(true);
        }

        @Override
        public void visitEnd(IfElseBlockStatement node, BooleanScope scope) {
            scope.setValue(true);
        }
    };
    private final List<Statement> statements;
    private final Location loc;
    private final LocalVariableScope locals;
    private final boolean isBracketed;
    private final boolean isNotUnbracketedIf;
    private int indexToStartEmitStatements = 0;

    private BlockStatement(Builder builder) {
        super(builder.definingNode);
        this.loc = builder.loc;
        this.statements = (List)builder.statements.apply(this);
        this.isBracketed = builder.isBracketed;
        this.locals = new LocalVariableScope();
        boolean bl = this.isNotUnbracketedIf = this.isBracketed || builder.definingNode == null || !BooleanScope.evaluate(builder.definingNode, INSIDE_IF_ELSE_BLOCK, false);
        if (MoreIterables.ensureAny(this.statements, Statement::isReturnable)) {
            this.setReturnable();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private static UnreachableStatementChecker createUnreachableStatementChecker(Statement node) {
        Version version = VersionUtil.get(node);
        if (version.isLessThanOrEqual(Version.COMPILER_RELEASE)) {
            return version.isLessThanOrEqual(Version.V146) || !node.isReturnable() ? Noop.INSTANCE : OldAndBusted.INSTANCE;
        }
        return AsGoodAsJava.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        try {
            if (visitor.visit(this, scope)) {
                for (Statement statement : this.statements) {
                    statement.traverse(visitor, scope);
                }
            }
            visitor.visitEnd(this, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            for (Statement statement : this.statements) {
                statement.validate(symbols, scope);
                scope.incrementBlock();
            }
            BlockStatement.createUnreachableStatementChecker(this).check(scope, this);
            if (scope.getErrors().isInvalid(this.statements)) {
                scope.getErrors().markInvalid(this);
            }
        }
        finally {
            scope.pop(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        if (this.isBracketed) {
            emitter.emitStatementExecuted(this.loc, this.indexToStartEmitStatements == this.statements.size(), false);
        }
        for (int i = this.indexToStartEmitStatements; i < this.statements.size(); ++i) {
            this.statements.get(i).emit(emitter);
        }
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    void emitFirstStatement(Emitter emitter) {
        assert (this.indexToStartEmitStatements == 0) : "already emitted first statement!";
        Preconditions.checkElementIndex(0, this.statements.size());
        this.statements.get(0).emit(emitter);
        this.indexToStartEmitStatements = 1;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public LocalVariableScope getLocals() {
        return this.locals;
    }

    public boolean isNotUnbracketedIf() {
        return this.isNotUnbracketedIf;
    }

    public static class Builder {
        private Function<AstNode, List<Statement>> statements;
        private Location loc;
        private AstNode definingNode;
        private boolean isBracketed = true;

        private Builder() {
        }

        public Builder setStatement(Statement statement) {
            assert (this.statements == null) : "statements already set";
            this.loc = statement.getLoc();
            this.statements = node -> ImmutableList.of(statement);
            this.isBracketed = false;
            return this;
        }

        public Builder setStmnt(Optional<Stmnt> stmnt) {
            assert (this.statements == null) : "statements already set";
            return stmnt != null && stmnt.isPresent() ? this.setStmnt(stmnt.get()) : this.setStatement(StatementExecuted.createReal(this.definingNode, this.definingNode.getLoc(), true, false));
        }

        public Builder setStmnt(Stmnt stmnt) {
            assert (this.statements == null) : "statements already set";
            this.loc = Locations.from(stmnt);
            this.statements = stmnt == null ? node -> ImmutableList.of() : node -> stmnt.match(new Stmnt.MatchBlockWithDefault<List<Statement>>(){

                @Override
                public List<Statement> _case(Stmnt.BlockStmnt blockStmnt) {
                    return AstNodes.get().createStatements(node, blockStmnt.stmnts);
                }

                @Override
                protected List<Statement> _default(Stmnt stmnt) {
                    isBracketed = false;
                    return ImmutableList.of(AstNodes.get().create(node, stmnt));
                }
            });
            return this;
        }

        public Builder setDefiningNode(AstNode definingNode) {
            this.definingNode = definingNode;
            return this;
        }

        public BlockStatement build() {
            return new BlockStatement(this);
        }
    }

    private static class AsGoodAsJava
    implements UnreachableStatementChecker {
        private static final AsGoodAsJava INSTANCE = new AsGoodAsJava();

        private AsGoodAsJava() {
        }

        @Override
        public void check(ValidationScope scope, BlockStatement block) {
            List statements = block.statements;
            for (int i = 0; i < statements.size() - 1; ++i) {
                if (!((Statement)statements.get(i)).isReturnable()) continue;
                scope.getErrors().markInvalid((AstNode)statements.get(i + 1), I18nSupport.getLabel("unreachable.statement"));
                break;
            }
        }
    }

    private static class OldAndBusted
    implements UnreachableStatementChecker {
        private static final OldAndBusted INSTANCE = new OldAndBusted();

        private OldAndBusted() {
        }

        @Override
        public void check(ValidationScope scope, BlockStatement block) {
            if (scope.isTopLevelBlock() && !scope.isOutsideMethod() && MethodUtil.returnsNonVoid(scope.getMethod()) && !StatementUtil.isLastStatementReturnable(block)) {
                scope.getErrors().markInvalid((AstNode)Iterables.getLast(block.statements), I18nSupport.getLabel("unreachable.statement"));
            }
        }
    }

    private static class Noop
    implements UnreachableStatementChecker {
        private static final Noop INSTANCE = new Noop();

        private Noop() {
        }

        @Override
        public void check(ValidationScope scope, BlockStatement block) {
        }
    }

    private static interface UnreachableStatementChecker {
        public void check(ValidationScope var1, BlockStatement var2);
    }
}

