/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor.reference;

import apex.common.base.ObjectHash;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.symbol.member.variable.Variable;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class ReferenceInfo {
    static final ReferenceInfo DELETE = ReferenceInfo.builder().setDmlOperation(DmlOperation.DELETE).build();
    static final ReferenceInfo INSERT = ReferenceInfo.builder().setDmlOperation(DmlOperation.INSERT).build();
    static final ReferenceInfo MERGE = ReferenceInfo.builder().setDmlOperation(DmlOperation.MERGE).build();
    static final ReferenceInfo UNDELETE = ReferenceInfo.builder().setDmlOperation(DmlOperation.UNDELETE).build();
    static final ReferenceInfo UPDATE = ReferenceInfo.builder().setDmlOperation(DmlOperation.UPDATE).build();
    static final ReferenceInfo UPSERT = ReferenceInfo.builder().setDmlOperation(DmlOperation.UPSERT).build();
    private static final ReferenceInfo EMPTY = ReferenceInfo.builder().build();
    private final Variable variable;
    private final DmlOperation dmlOperation;
    private final boolean referencedViaForeignKey;
    private final boolean isLast;

    private ReferenceInfo(Builder builder) {
        this.variable = builder.variable;
        this.dmlOperation = builder.dmlOperation;
        this.referencedViaForeignKey = builder.referencedViaForeignKey;
        this.isLast = builder.isLast;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ReferenceInfo empty() {
        return EMPTY;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public boolean isReferencedViaForeignKey() {
        return this.referencedViaForeignKey;
    }

    public int hashCode() {
        return ObjectHash.hash(this.variable, (Object)this.dmlOperation, this.referencedViaForeignKey, this.isLast);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferenceInfo that = (ReferenceInfo)o;
        return Objects.equals(this.variable, that.variable) && this.dmlOperation == that.dmlOperation && Objects.equals(this.referencedViaForeignKey, that.referencedViaForeignKey) && Objects.equals(this.isLast, that.isLast);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("variable", this.variable).add("dmlOperation", (Object)this.dmlOperation).add("referencedViaForeignKey", this.referencedViaForeignKey).add("isLast", this.isLast).toString();
    }

    public DmlOperation getDmlOperation() {
        return this.dmlOperation;
    }

    public static class Builder {
        private Variable variable;
        private DmlOperation dmlOperation;
        private boolean referencedViaForeignKey;
        private boolean isLast;

        private Builder() {
        }

        public ReferenceInfo build() {
            return new ReferenceInfo(this);
        }

        public Builder setDmlOperation(DmlOperation dmlOperation) {
            this.dmlOperation = dmlOperation;
            return this;
        }

        public Builder setVariable(Variable variable) {
            this.variable = variable;
            return this;
        }

        public Builder setLast(boolean isLast) {
            this.isLast = isLast;
            return this;
        }

        public Builder setReferencedViaForeignKey(boolean referencedViaForeignKey) {
            this.referencedViaForeignKey = referencedViaForeignKey;
            return this;
        }
    }
}

