/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.database;

import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.util.database.DBURI;
import net.sourceforge.pmd.util.database.SourceObject;

public class DBMSMetadata {
    private static final String CLASS_NAME = DBMSMetadata.class.getCanonicalName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private static final String GET_SOURCE_OBJECTS_STATEMENT = "getSourceObjectsStatement";
    private static final String GET_SOURCE_CODE_STATEMENT = "getSourceCodeStatement";
    protected DBURI dburi = null;
    protected Connection connection = null;
    protected String returnSourceCodeObjectsStatement = null;
    protected String returnSourceCodeStatement = null;
    protected CallableStatement callableStatement = null;
    protected int returnType = 2005;

    public DBMSMetadata(Connection c) throws SQLException {
        this.connection = c;
    }

    public DBMSMetadata(String user, String password, DBURI dbURI) throws SQLException, MalformedURLException, ClassNotFoundException {
        String urlString = this.init(dbURI);
        Properties mergedProperties = dbURI.getDbType().getProperties();
        Map<String, String> dbURIParameters = dbURI.getParameters();
        mergedProperties.putAll(dbURIParameters);
        mergedProperties.put("user", user);
        mergedProperties.put("password", password);
        this.connection = DriverManager.getConnection(urlString, mergedProperties);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("we have a connection=" + this.connection);
        }
    }

    public DBMSMetadata(Properties properties, DBURI dbURI) throws SQLException, MalformedURLException, ClassNotFoundException {
        String urlString = this.init(dbURI);
        Properties mergedProperties = dbURI.getDbType().getProperties();
        Map<String, String> dbURIParameters = dbURI.getParameters();
        mergedProperties.putAll(dbURIParameters);
        mergedProperties.putAll((Map<?, ?>)properties);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Retrieving connection for urlString" + urlString);
        }
        this.connection = DriverManager.getConnection(urlString, mergedProperties);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Secured Connection for DBURI" + dbURI);
        }
    }

    public DBMSMetadata(DBURI dbURI) throws SQLException, ClassNotFoundException {
        String urlString = this.init(dbURI);
        Properties dbURIProperties = dbURI.getDbType().getProperties();
        Map<String, String> dbURIParameters = dbURI.getParameters();
        dbURIProperties.putAll(dbURIParameters);
        this.connection = DriverManager.getConnection(urlString, dbURIProperties);
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    private String init(DBURI dbURI) throws ClassNotFoundException {
        this.dburi = dbURI;
        this.returnSourceCodeObjectsStatement = dbURI.getDbType().getProperties().getProperty(GET_SOURCE_OBJECTS_STATEMENT);
        this.returnSourceCodeStatement = dbURI.getDbType().getProperties().getProperty(GET_SOURCE_CODE_STATEMENT);
        this.returnType = dbURI.getSourceCodeType();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("returnSourceCodeStatement=" + this.returnSourceCodeStatement + ", returnType=" + this.returnType);
        }
        String driverClass = dbURI.getDriverClass();
        String urlString = dbURI.getURL().toString();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("driverClass=" + driverClass + ", urlString=" + urlString);
        }
        Class.forName(driverClass);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Located class for driverClass=" + driverClass);
        }
        return urlString;
    }

    public Reader getSourceCode(SourceObject sourceObject) throws SQLException {
        return this.getSourceCode(sourceObject.getType(), sourceObject.getName(), sourceObject.getSchema());
    }

    public Reader getSourceCode(String objectType, String name, String schema) throws SQLException {
        if (null == this.callableStatement) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("getSourceCode: returnSourceCodeStatement=\"" + this.returnSourceCodeStatement + "\"");
                LOGGER.finest("getSourceCode: returnType=\"" + this.returnType + "\"");
            }
            this.callableStatement = this.getConnection().prepareCall(this.returnSourceCodeStatement);
            this.callableStatement.registerOutParameter(1, this.returnType);
        }
        this.callableStatement.setString(2, objectType);
        this.callableStatement.setString(3, name);
        this.callableStatement.setString(4, schema);
        this.callableStatement.executeUpdate();
        Object result = this.callableStatement.getObject(1);
        return 2005 == this.returnType ? ((Clob)result).getCharacterStream() : new StringReader(result.toString());
    }

    public List<SourceObject> getSourceObjectList() {
        if (null == this.dburi) {
            LOGGER.warning("No dbUri defined - no further action possible");
            return null;
        }
        return this.getSourceObjectList(this.dburi.getLanguagesList(), this.dburi.getSchemasList(), this.dburi.getSourceCodeTypesList(), this.dburi.getSourceCodeNamesList());
    }

    public List<SourceObject> getSourceObjectList(List<String> languages, List<String> schemas, List<String> sourceCodeTypes, List<String> sourceCodeNames) {
        List<String> dbURIList;
        ArrayList<SourceObject> sourceObjectsList = new ArrayList<SourceObject>();
        List<String> searchLanguages = languages;
        List<String> searchSchemas = schemas;
        List<String> searchSourceCodeTypes = sourceCodeTypes;
        List<String> searchSourceCodeNames = sourceCodeNames;
        List<String> wildcardList = Arrays.asList("%");
        if (null == searchLanguages) {
            dbURIList = null == this.dburi ? null : this.dburi.getLanguagesList();
            searchLanguages = null == dbURIList || dbURIList.isEmpty() ? wildcardList : dbURIList;
        }
        if (null == searchSchemas) {
            dbURIList = null == this.dburi ? null : this.dburi.getSchemasList();
            searchSchemas = null == dbURIList || dbURIList.isEmpty() ? wildcardList : dbURIList;
        }
        if (null == searchSourceCodeTypes) {
            dbURIList = null == this.dburi ? null : this.dburi.getSourceCodeTypesList();
            searchSourceCodeTypes = null == dbURIList || dbURIList.isEmpty() ? wildcardList : dbURIList;
        }
        if (null == searchSourceCodeNames) {
            dbURIList = null == this.dburi ? null : this.dburi.getSourceCodeNamesList();
            searchSourceCodeNames = null == dbURIList || dbURIList.isEmpty() ? wildcardList : dbURIList;
        }
        try {
            if (null != this.returnSourceCodeObjectsStatement) {
                LOGGER.log(Level.FINE, "Have bespoke returnSourceCodeObjectsStatement from DBURI: \"{0}\"", this.returnSourceCodeObjectsStatement);
                try (PreparedStatement sourceCodeObjectsStatement = this.getConnection().prepareStatement(this.returnSourceCodeObjectsStatement);){
                    for (String language : searchLanguages) {
                        for (String schema : searchSchemas) {
                            for (String sourceCodeType : searchSourceCodeTypes) {
                                for (String sourceCodeName : searchSourceCodeNames) {
                                    sourceObjectsList.addAll(this.findSourceObjects(sourceCodeObjectsStatement, language, schema, sourceCodeType, sourceCodeName));
                                }
                            }
                        }
                    }
                }
            } else {
                LOGGER.fine("Have dbUri - no returnSourceCodeObjectsStatement, reverting to DatabaseMetaData.getProcedures(...)");
                DatabaseMetaData metadata = this.connection.getMetaData();
                List<String> schemasList = this.dburi.getSchemasList();
                for (String schema : schemasList) {
                    for (String sourceCodeName : this.dburi.getSourceCodeNamesList()) {
                        sourceObjectsList.addAll(this.findSourceObjectFromMetaData(metadata, schema, sourceCodeName));
                    }
                }
            }
            LOGGER.finer(String.format("Identfied=%d sourceObjects", sourceObjectsList.size()));
            return sourceObjectsList;
        }
        catch (SQLException sqle) {
            throw new RuntimeException("Problem collecting list of source code objects", sqle);
        }
    }

    private List<SourceObject> findSourceObjectFromMetaData(DatabaseMetaData metadata, String schema, String sourceCodeName) throws SQLException {
        ArrayList<SourceObject> sourceObjectsList = new ArrayList<SourceObject>();
        try (ResultSet sourceCodeObjects = metadata.getProcedures(null, schema, sourceCodeName);){
            while (sourceCodeObjects.next()) {
                LOGGER.finest(String.format("Located schema=%s,object_type=%s,object_name=%s\n", sourceCodeObjects.getString("PROCEDURE_SCHEM"), sourceCodeObjects.getString("PROCEDURE_TYPE"), sourceCodeObjects.getString("PROCEDURE_NAME")));
                sourceObjectsList.add(new SourceObject(sourceCodeObjects.getString("PROCEDURE_SCHEM"), sourceCodeObjects.getString("PROCEDURE_TYPE"), sourceCodeObjects.getString("PROCEDURE_NAME"), null));
            }
        }
        return sourceObjectsList;
    }

    private List<SourceObject> findSourceObjects(PreparedStatement sourceCodeObjectsStatement, String language, String schema, String sourceCodeType, String sourceCodeName) throws SQLException {
        ArrayList<SourceObject> sourceObjectsList = new ArrayList<SourceObject>();
        sourceCodeObjectsStatement.setString(1, language);
        sourceCodeObjectsStatement.setString(2, schema);
        sourceCodeObjectsStatement.setString(3, sourceCodeType);
        sourceCodeObjectsStatement.setString(4, sourceCodeName);
        LOGGER.finer(String.format("searching for language=\"%s\", schema=\"%s\", sourceCodeType=\"%s\", sourceCodeNames=\"%s\" ", language, schema, sourceCodeType, sourceCodeName));
        try (ResultSet sourceCodeObjects = sourceCodeObjectsStatement.executeQuery();){
            while (sourceCodeObjects.next()) {
                LOGGER.finest(String.format("Found schema=%s,object_type=%s,object_name=%s", sourceCodeObjects.getString("PROCEDURE_SCHEM"), sourceCodeObjects.getString("PROCEDURE_TYPE"), sourceCodeObjects.getString("PROCEDURE_NAME")));
                sourceObjectsList.add(new SourceObject(sourceCodeObjects.getString("PROCEDURE_SCHEM"), sourceCodeObjects.getString("PROCEDURE_TYPE"), sourceCodeObjects.getString("PROCEDURE_NAME"), null));
            }
        }
        return sourceObjectsList;
    }
}

