/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.codeActions.quickFix;

import apex.jorje.data.Locations;
import apex.jorje.data.TypeRefBuilder;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.LiteralType;
import apex.jorje.data.ast.MethodDecl;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.lsp.api.codeActions.QuickFixProvider;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.visitors.VisitorFactory;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.codeActions.BaseCodeActionsProvider;
import apex.jorje.lsp.impl.codeActions.CodeActionValidations;
import apex.jorje.lsp.impl.codeActions.quickFix.QuickFixException;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.telemetry.TelemetryData;
import apex.jorje.lsp.impl.utils.CodeActionsUtil;
import apex.jorje.lsp.impl.visitors.codeActions.MissingMethodScope;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.printers.PrintContexts;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class DeclareMissingMethodProvider
extends BaseCodeActionsProvider
implements QuickFixProvider {
    private static final String TELEMETRY_NAME = "DeclareMissingMethod";

    @Inject
    public DeclareMissingMethodProvider(ApexCompilerService compilerService, ApexDocumentService docService, VisitorFactory visitorFactory) {
        super(compilerService, docService, visitorFactory);
    }

    @Override
    protected List<Either<Command, CodeAction>> getCodeActions(Document doc, Range range, TelemetryData telemetryData) throws BadLocationException {
        ArrayList<Either<Command, CodeAction>> codeActions = Lists.newArrayList();
        MissingMethodScope scope = new MissingMethodScope(doc, range, this.docService, this.compilerService);
        this.compileAndTraverse(doc, this.visitorFactory.createDeclareMissingMethodVisitor(), scope);
        Optional<MethodCallExpression> optMethodCall = scope.getMethodCall();
        if (optMethodCall.isPresent()) {
            this.setTelemetryData(scope, telemetryData);
            MethodCallExpression methodCall = optMethodCall.get();
            GeneratedMethod generatedMethod = this.generateMethod(scope);
            CodeAction action = new CodeAction(I18nSupport.getLabel("declare.missing.method", methodCall.getMethodName(), methodCall.getReferenceType().getCodeUnitDetails().getName()));
            action.setKind("quickfix");
            action.setEdit(CodeActionsUtil.getWorkspaceEdit(generatedMethod.getUri().toString(), generatedMethod.getRangeToInsert(), generatedMethod.getSource()));
            codeActions.add((Either<Command, CodeAction>)Either.forRight((Object)action));
        }
        return codeActions;
    }

    private GeneratedMethod generateMethod(MissingMethodScope scope) throws BadLocationException {
        GeneratedMethod method = null;
        Optional<MethodCallExpression> optMethodCall = scope.getMethodCall();
        if (optMethodCall.isPresent()) {
            method = new GeneratedMethod(scope);
            MethodCallExpression methodCall = optMethodCall.get();
            String returnType = scope.getReturnType().isPresent() ? scope.getReturnType().get().getApexName() : "void";
            MethodDecl declaration = new MethodDecl(this.getModifiers(methodCall), Optional.of(TypeRefBuilder.withNames(returnType.split("\\.")).build()), methodCall.getNameUsed(), scope.getParameterRefs(), Optional.of(Stmnt._BlockStmnt(Locations.NONE, this.getMethodBody(scope))));
            Printer<MethodDecl> printer = PrinterUtil.get().getFactory(method.getIndentLevel(), method.getIndent()).methodDeclPrinter();
            method.setSource(printer.print(declaration, PrintContexts.empty()));
        }
        return method;
    }

    private List<Stmnt> getMethodBody(MissingMethodScope scope) {
        Stmnt returnStatement = Stmnt._ReturnStmnt(Locations.NONE, Optional.of(Expr._LiteralExpr(Locations.NONE, LiteralType.NULL, null)));
        return scope.getReturnType().isPresent() ? ImmutableList.of(returnStatement) : ImmutableList.of();
    }

    private List<Modifier> getModifiers(MethodCallExpression methodCall) {
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        if (TypeInfoEquivalence.isEquivalent(methodCall.getReferenceType(), methodCall.getDefiningType())) {
            modifiers.add(Modifier._PrivateModifier(Locations.NONE));
        } else {
            modifiers.add(Modifier._PublicModifier(Locations.NONE));
        }
        if (methodCall.getReferenceContext().getContext() == IdentifierContext.STATIC) {
            modifiers.add(Modifier._StaticModifier(Locations.NONE));
        }
        return modifiers;
    }

    private void setTelemetryData(MissingMethodScope scope, TelemetryData telemetryData) {
        telemetryData.add("CodeActionName", TELEMETRY_NAME);
        telemetryData.add("CodeActionKind", "quickfix");
        scope.getMethodCall().ifPresent(methodCall -> telemetryData.add("DefiningNode", methodCall.getDefiningNode().getClass().getSimpleName()));
    }

    @Override
    public List<QuickFixException> getQuickFixExceptions(CodeUnit codeUnit) {
        final ArrayList<QuickFixException> exceptions = new ArrayList<QuickFixException>();
        codeUnit.getNode().traverse(new AstVisitor<NoopScope>(){

            @Override
            protected boolean defaultVisit() {
                return true;
            }

            @Override
            public void visitEnd(MethodCallExpression methodCall, NoopScope scope) {
                super.visitEnd(methodCall, scope);
                if (CodeActionValidations.canDeclareMethod(methodCall)) {
                    exceptions.add(new QuickFixException(methodCall.getLoc(), I18nSupport.getLabel("declare.missing.method.available", methodCall.getMethodName())));
                }
            }
        }, NoopScope.get());
        return exceptions;
    }

    public static class GeneratedMethod {
        private static final String SOURCE_PREFIX = "\n\n";
        private static final String SPACE_INDENT = " ";
        private static final String TAB_INDENT = "\t";
        private final MissingMethodScope scope;
        private final Position basePosition;
        private String source;

        GeneratedMethod(MissingMethodScope scope) throws BadLocationException {
            this.scope = scope;
            this.basePosition = apex.jorje.lsp.impl.utils.Locations.from(scope.getDefiningDocument(), scope.getDefiningUserClass().get().getBodyLoc()).getRange().getEnd();
        }

        String getSource() {
            return this.source;
        }

        void setSource(String source) {
            this.source = SOURCE_PREFIX + source;
        }

        Range getRangeToInsert() throws BadLocationException {
            int line = this.basePosition.getLine() > 0 ? this.basePosition.getLine() - 1 : 0;
            int col = this.scope.getDefiningDocument().getLineLength(line);
            Position insertPos = new Position(line, col);
            return new Range(insertPos, insertPos);
        }

        String getIndent() {
            return this.basePosition.getCharacter() > 1 ? SPACE_INDENT : TAB_INDENT;
        }

        int getIndentLevel() {
            return this.basePosition.getCharacter() > 1 ? (this.basePosition.getCharacter() - 1) * 2 : 1;
        }

        URI getUri() {
            return this.scope.getDefiningDocument().getUri();
        }
    }
}

