/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.utils;

import apex.jorje.data.Location;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.impl.document.BadLocationException;
import java.net.URI;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class Locations {
    private Locations() {
    }

    public static org.eclipse.lsp4j.Location from(URI docUri, Location jorjeLoc) {
        return new org.eclipse.lsp4j.Location(docUri.toString(), Ranges.from(jorjeLoc));
    }

    public static org.eclipse.lsp4j.Location from(Document doc, Location jorjeLoc) throws BadLocationException {
        return new org.eclipse.lsp4j.Location(doc.getUri().toString(), Ranges.from(doc, jorjeLoc));
    }

    public static int getOffset(Document document, Position position) throws BadLocationException {
        return document.getLineOffset(position.getLine()) + position.getCharacter();
    }

    public static class Ranges {
        private Ranges() {
        }

        public static Range from(Location loc) {
            return Ranges.from(loc.getStartIndex(), loc.getEndIndex(), loc.getLine(), loc.getColumn());
        }

        public static Range from(int startIndex, int endIndex, int lineNumber, int column) {
            assert (startIndex > -1) : "Negative start index provided";
            assert (endIndex > -1) : "Negative end index provided";
            assert (endIndex >= startIndex) : "End index greater than start index";
            int normalizedLine = lineNumber >= 1 ? lineNumber - 1 : 0;
            int tokenStartCol = column >= 1 ? column - 1 : 0;
            int tokenLength = endIndex - startIndex;
            int tokenEndCol = tokenStartCol + tokenLength;
            return new Range(new Position(normalizedLine, tokenStartCol), new Position(normalizedLine, tokenEndCol));
        }

        public static Range from(Document doc, Location loc) throws BadLocationException {
            return Ranges.from(doc, loc.getStartIndex(), loc.getEndIndex(), loc.getLine(), loc.getColumn());
        }

        public static Range from(Document doc, int startIndex, int endIndex, int lineNum, int column) throws BadLocationException {
            Range range = Ranges.from(startIndex, endIndex, lineNum, column);
            Position endPosition = range.getEnd();
            int endLine = doc.getLineNumberOfOffset(endIndex);
            endPosition.setLine(endLine);
            endPosition.setCharacter(endIndex - doc.getLineOffset(endLine));
            range.setEnd(endPosition);
            return range;
        }
    }
}

