/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

class CollectionExpressionUtils {
    private CollectionExpressionUtils() {
    }

    static boolean validateCollection(TypeInfo referencingType, List<TypeInfo> typesToCheck, ValidationScope validationScope, AstNode nodeToAddErrorsTo) {
        List<String> unresolvedErrors = UnresolvedErrorCalculator.getErrors(typesToCheck);
        validationScope.getErrors().markInvalid(nodeToAddErrorsTo, unresolvedErrors);
        ArrayList<String> errors = new ArrayList<String>();
        for (TypeInfo type : typesToCheck) {
            if (Visibility.isTypeVisible(validationScope.getSymbols().getAccessEvaluator(), referencingType, type, Visibility.ReferencedFromTestMethod.fromBoolean(validationScope.isTestMethod()), Visibility.CheckGenericTypeArguments.YES)) continue;
            errors.add(I18nSupport.getLabel("type.not.visible", type.getApexName()));
        }
        if (!errors.isEmpty()) {
            validationScope.getErrors().markInvalid(nodeToAddErrorsTo, (List<String>)errors);
            return false;
        }
        return true;
    }

    static boolean validateMap(TypeInfo referencingType, TypeInfo keyType, TypeInfo valueType, ValidationScope validationScope, AstNode nodeToAddErrorsTo) {
        if (!CollectionExpressionUtils.validateCollection(referencingType, Lists.newArrayList(keyType, valueType), validationScope, nodeToAddErrorsTo)) {
            return false;
        }
        return CollectionExpressionUtils.validateTypeIsNotSObjectBeforeV164(valueType, referencingType, validationScope, nodeToAddErrorsTo, I18nSupport.getLabel("invalid.sobject.map"));
    }

    static boolean validateList(TypeInfo referencingType, TypeInfo elementType, ValidationScope validationScope, AstNode nodeToAddErrorsTo) {
        if (!CollectionExpressionUtils.validateCollection(referencingType, ImmutableList.of(elementType), validationScope, nodeToAddErrorsTo)) {
            return false;
        }
        return CollectionExpressionUtils.validateTypeIsNotSObjectBeforeV164(elementType, referencingType, validationScope, nodeToAddErrorsTo, I18nSupport.getLabel("invalid.sobject.list"));
    }

    private static boolean validateTypeIsNotSObjectBeforeV164(TypeInfo type, TypeInfo referencingType, ValidationScope errorsScope, AstNode nodeToAddErrorsTo, String errorMessage) {
        if (TypeInfoEquivalence.isEquivalent(type, TypeInfos.SOBJECT) && Version.V164.isGreaterThan(referencingType.getCodeUnitDetails().getVersion())) {
            errorsScope.getErrors().markInvalid(nodeToAddErrorsTo, errorMessage);
            return false;
        }
        return true;
    }
}

