/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.reference;

import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.TypeRefs;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.reference.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Optional;

public class TypeReferences {
    public static final TypeRef GENERATED_TYPE_REF = TypeRefs.newClassTypeRef(ImmutableList.of(), ImmutableList.of());
    public static final TypeReference VOID = TypeReferences.createResolved(TypeInfos.VOID);
    public static final TypeReference SOBJECT = TypeReferences.createResolved(TypeInfos.SOBJECT);

    private TypeReferences() {
    }

    public static TypeReference createResolved(TypeInfo type) {
        return new ResolvedTypeRef(type);
    }

    public static TypeReference createResolvable(TypeRef typeRef) {
        return new ResolvableTypeRef(typeRef);
    }

    private static class ResolvableTypeRef
    implements TypeReference {
        private final TypeRef typeRef;
        private TypeInfo type;

        private ResolvableTypeRef(TypeRef typeRef) {
            this.typeRef = typeRef;
        }

        @Override
        public TypeInfo resolve(SymbolResolver symbols, TypeInfo definingType) {
            return this.type == null ? (this.type = symbols.lookupTypeInfo(definingType, this.typeRef)) : this.type;
        }

        @Override
        public TypeInfo get() {
            Preconditions.checkNotNull(this.type);
            return this.type;
        }

        @Override
        public TypeRef getRef() {
            return this.typeRef;
        }

        public String toString() {
            return Optional.ofNullable(this.type).map(Object::toString).orElse(this.typeRef.toString());
        }
    }

    private static class ResolvedTypeRef
    implements TypeReference {
        private final TypeInfo type;

        private ResolvedTypeRef(TypeInfo type) {
            this.type = type;
        }

        @Override
        public TypeInfo resolve(SymbolResolver symbols, TypeInfo definingType) {
            return this.type;
        }

        public String toString() {
            return this.type.toString();
        }

        @Override
        public TypeInfo get() {
            return this.type;
        }

        @Override
        public TypeRef getRef() {
            return GENERATED_TYPE_REF;
        }
    }
}

