/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.soql;

import apex.jorje.data.soql.DistanceFunctionExpr;
import apex.jorje.data.soql.Field;
import apex.jorje.data.soql.Order;
import apex.jorje.data.soql.OrderByExpr;
import apex.jorje.data.soql.OrderNull;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.soql.DistanceFunctionExprPrinter;
import apex.jorje.services.printers.soql.FieldPrinter;

public class OrderByExprPrinter
implements Printer<OrderByExpr> {
    private static final Printer<OrderByExpr> INSTANCE = new OrderByExprPrinter(FieldPrinter.get(), DistanceFunctionExprPrinter.get());
    private static final Order.MatchBlock<String> ORDER_MATCH = new Order.MatchBlock<String>(){

        @Override
        public String _case(Order.OrderAsc x) {
            return " ASC";
        }

        @Override
        public String _case(Order.OrderDesc x) {
            return " DESC";
        }
    };
    private static final OrderNull.MatchBlock<String> NULL_ORDER_MATCH = new OrderNull.MatchBlock<String>(){

        @Override
        public String _case(OrderNull.OrderNullLast x) {
            return " NULLS LAST";
        }

        @Override
        public String _case(OrderNull.OrderNullFirst x) {
            return " NULLS FIRST";
        }
    };
    private final Printer<Field> fieldPrinter;
    private final Printer<DistanceFunctionExpr> distanceFunctionExprPrinter;

    private OrderByExprPrinter(Printer<Field> fieldPrinter, Printer<DistanceFunctionExpr> distanceFunctionExprPrinter) {
        this.fieldPrinter = fieldPrinter;
        this.distanceFunctionExprPrinter = distanceFunctionExprPrinter;
    }

    public static Printer<OrderByExpr> get() {
        return INSTANCE;
    }

    @Override
    public String print(OrderByExpr x, final PrintContext ctx) {
        return x.match(new OrderByExpr.MatchBlock<String>(){

            @Override
            public String _case(OrderByExpr.OrderByDistance x) {
                return OrderByExprPrinter.this.distanceFunctionExprPrinter.print(x.distance, ctx) + (String)x.order.match(ORDER_MATCH) + (String)x.nullOrder.match(NULL_ORDER_MATCH);
            }

            @Override
            public String _case(OrderByExpr.OrderByValue x) {
                return OrderByExprPrinter.this.fieldPrinter.print(x.field, ctx) + (String)x.order.match(ORDER_MATCH) + (String)x.nullOrder.match(NULL_ORDER_MATCH);
            }
        });
    }
}

