/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers.internal.sarif;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SarifLog {
    @SerializedName(value="$schema")
    private String schema;
    private String version;
    private List<Run> runs;

    private static String defaultSchema() {
        return "https://raw.githubusercontent.com/oasis-tcs/sarif-spec/master/Schemata/sarif-schema-2.1.0.json";
    }

    private static String defaultVersion() {
        return "2.1.0";
    }

    SarifLog(String schema, String version, List<Run> runs) {
        this.schema = schema;
        this.version = version;
        this.runs = runs;
    }

    public static SarifLogBuilder builder() {
        return new SarifLogBuilder();
    }

    public String getSchema() {
        return this.schema;
    }

    public String getVersion() {
        return this.version;
    }

    public List<Run> getRuns() {
        return this.runs;
    }

    public SarifLog setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public SarifLog setVersion(String version) {
        this.version = version;
        return this;
    }

    public SarifLog setRuns(List<Run> runs) {
        this.runs = runs;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SarifLog)) {
            return false;
        }
        SarifLog other = (SarifLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        List<Run> this$runs = this.getRuns();
        List<Run> other$runs = other.getRuns();
        return !(this$runs == null ? other$runs != null : !((Object)this$runs).equals(other$runs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SarifLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        List<Run> $runs = this.getRuns();
        result = result * 59 + ($runs == null ? 43 : ((Object)$runs).hashCode());
        return result;
    }

    public String toString() {
        return "SarifLog(schema=" + this.getSchema() + ", version=" + this.getVersion() + ", runs=" + this.getRuns() + ")";
    }

    public static class SarifLogBuilder {
        private boolean schemaSet;
        private String schemaValue;
        private boolean versionSet;
        private String versionValue;
        private List<Run> runs;

        SarifLogBuilder() {
        }

        public SarifLogBuilder schema(String schema) {
            this.schemaValue = schema;
            this.schemaSet = true;
            return this;
        }

        public SarifLogBuilder version(String version) {
            this.versionValue = version;
            this.versionSet = true;
            return this;
        }

        public SarifLogBuilder runs(List<Run> runs) {
            this.runs = runs;
            return this;
        }

        public SarifLog build() {
            String schemaValue = this.schemaValue;
            if (!this.schemaSet) {
                schemaValue = SarifLog.defaultSchema();
            }
            String versionValue = this.versionValue;
            if (!this.versionSet) {
                versionValue = SarifLog.defaultVersion();
            }
            return new SarifLog(schemaValue, versionValue, this.runs);
        }

        public String toString() {
            return "SarifLog.SarifLogBuilder(schema$value=" + this.schemaValue + ", version$value=" + this.versionValue + ", runs=" + this.runs + ")";
        }
    }

    public static class Invocation {
        private Boolean executionSuccessful;
        private List<ToolConfigurationNotification> toolConfigurationNotifications;
        private List<ToolExecutionNotification> toolExecutionNotifications;

        Invocation(Boolean executionSuccessful, List<ToolConfigurationNotification> toolConfigurationNotifications, List<ToolExecutionNotification> toolExecutionNotifications) {
            this.executionSuccessful = executionSuccessful;
            this.toolConfigurationNotifications = toolConfigurationNotifications;
            this.toolExecutionNotifications = toolExecutionNotifications;
        }

        public static InvocationBuilder builder() {
            return new InvocationBuilder();
        }

        public InvocationBuilder toBuilder() {
            return new InvocationBuilder().executionSuccessful(this.executionSuccessful).toolConfigurationNotifications(this.toolConfigurationNotifications).toolExecutionNotifications(this.toolExecutionNotifications);
        }

        public Boolean getExecutionSuccessful() {
            return this.executionSuccessful;
        }

        public List<ToolConfigurationNotification> getToolConfigurationNotifications() {
            return this.toolConfigurationNotifications;
        }

        public List<ToolExecutionNotification> getToolExecutionNotifications() {
            return this.toolExecutionNotifications;
        }

        public Invocation setExecutionSuccessful(Boolean executionSuccessful) {
            this.executionSuccessful = executionSuccessful;
            return this;
        }

        public Invocation setToolConfigurationNotifications(List<ToolConfigurationNotification> toolConfigurationNotifications) {
            this.toolConfigurationNotifications = toolConfigurationNotifications;
            return this;
        }

        public Invocation setToolExecutionNotifications(List<ToolExecutionNotification> toolExecutionNotifications) {
            this.toolExecutionNotifications = toolExecutionNotifications;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Invocation)) {
                return false;
            }
            Invocation other = (Invocation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$executionSuccessful = this.getExecutionSuccessful();
            Boolean other$executionSuccessful = other.getExecutionSuccessful();
            if (this$executionSuccessful == null ? other$executionSuccessful != null : !((Object)this$executionSuccessful).equals(other$executionSuccessful)) {
                return false;
            }
            List<ToolConfigurationNotification> this$toolConfigurationNotifications = this.getToolConfigurationNotifications();
            List<ToolConfigurationNotification> other$toolConfigurationNotifications = other.getToolConfigurationNotifications();
            if (this$toolConfigurationNotifications == null ? other$toolConfigurationNotifications != null : !((Object)this$toolConfigurationNotifications).equals(other$toolConfigurationNotifications)) {
                return false;
            }
            List<ToolExecutionNotification> this$toolExecutionNotifications = this.getToolExecutionNotifications();
            List<ToolExecutionNotification> other$toolExecutionNotifications = other.getToolExecutionNotifications();
            return !(this$toolExecutionNotifications == null ? other$toolExecutionNotifications != null : !((Object)this$toolExecutionNotifications).equals(other$toolExecutionNotifications));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Invocation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $executionSuccessful = this.getExecutionSuccessful();
            result = result * 59 + ($executionSuccessful == null ? 43 : ((Object)$executionSuccessful).hashCode());
            List<ToolConfigurationNotification> $toolConfigurationNotifications = this.getToolConfigurationNotifications();
            result = result * 59 + ($toolConfigurationNotifications == null ? 43 : ((Object)$toolConfigurationNotifications).hashCode());
            List<ToolExecutionNotification> $toolExecutionNotifications = this.getToolExecutionNotifications();
            result = result * 59 + ($toolExecutionNotifications == null ? 43 : ((Object)$toolExecutionNotifications).hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.Invocation(executionSuccessful=" + this.getExecutionSuccessful() + ", toolConfigurationNotifications=" + this.getToolConfigurationNotifications() + ", toolExecutionNotifications=" + this.getToolExecutionNotifications() + ")";
        }

        public static class InvocationBuilder {
            private Boolean executionSuccessful;
            private List<ToolConfigurationNotification> toolConfigurationNotifications;
            private List<ToolExecutionNotification> toolExecutionNotifications;

            InvocationBuilder() {
            }

            public InvocationBuilder executionSuccessful(Boolean executionSuccessful) {
                this.executionSuccessful = executionSuccessful;
                return this;
            }

            public InvocationBuilder toolConfigurationNotifications(List<ToolConfigurationNotification> toolConfigurationNotifications) {
                this.toolConfigurationNotifications = toolConfigurationNotifications;
                return this;
            }

            public InvocationBuilder toolExecutionNotifications(List<ToolExecutionNotification> toolExecutionNotifications) {
                this.toolExecutionNotifications = toolExecutionNotifications;
                return this;
            }

            public Invocation build() {
                return new Invocation(this.executionSuccessful, this.toolConfigurationNotifications, this.toolExecutionNotifications);
            }

            public String toString() {
                return "SarifLog.Invocation.InvocationBuilder(executionSuccessful=" + this.executionSuccessful + ", toolConfigurationNotifications=" + this.toolConfigurationNotifications + ", toolExecutionNotifications=" + this.toolExecutionNotifications + ")";
            }
        }
    }

    public static class ToolExecutionNotification {
        private List<Location> locations;
        private Message message;
        private Exception exception;

        ToolExecutionNotification(List<Location> locations, Message message, Exception exception) {
            this.locations = locations;
            this.message = message;
            this.exception = exception;
        }

        public static ToolExecutionNotificationBuilder builder() {
            return new ToolExecutionNotificationBuilder();
        }

        public ToolExecutionNotificationBuilder toBuilder() {
            return new ToolExecutionNotificationBuilder().locations(this.locations).message(this.message).exception(this.exception);
        }

        public List<Location> getLocations() {
            return this.locations;
        }

        public Message getMessage() {
            return this.message;
        }

        public Exception getException() {
            return this.exception;
        }

        public ToolExecutionNotification setLocations(List<Location> locations) {
            this.locations = locations;
            return this;
        }

        public ToolExecutionNotification setMessage(Message message) {
            this.message = message;
            return this;
        }

        public ToolExecutionNotification setException(Exception exception) {
            this.exception = exception;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ToolExecutionNotification)) {
                return false;
            }
            ToolExecutionNotification other = (ToolExecutionNotification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Location> this$locations = this.getLocations();
            List<Location> other$locations = other.getLocations();
            if (this$locations == null ? other$locations != null : !((Object)this$locations).equals(other$locations)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            Exception this$exception = this.getException();
            Exception other$exception = other.getException();
            return !(this$exception == null ? other$exception != null : !((Object)this$exception).equals(other$exception));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ToolExecutionNotification;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Location> $locations = this.getLocations();
            result = result * 59 + ($locations == null ? 43 : ((Object)$locations).hashCode());
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            Exception $exception = this.getException();
            result = result * 59 + ($exception == null ? 43 : ((Object)$exception).hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.ToolExecutionNotification(locations=" + this.getLocations() + ", message=" + this.getMessage() + ", exception=" + this.getException() + ")";
        }

        public static class ToolExecutionNotificationBuilder {
            private List<Location> locations;
            private Message message;
            private Exception exception;

            ToolExecutionNotificationBuilder() {
            }

            public ToolExecutionNotificationBuilder locations(List<Location> locations) {
                this.locations = locations;
                return this;
            }

            public ToolExecutionNotificationBuilder message(Message message) {
                this.message = message;
                return this;
            }

            public ToolExecutionNotificationBuilder exception(Exception exception) {
                this.exception = exception;
                return this;
            }

            public ToolExecutionNotification build() {
                return new ToolExecutionNotification(this.locations, this.message, this.exception);
            }

            public String toString() {
                return "SarifLog.ToolExecutionNotification.ToolExecutionNotificationBuilder(locations=" + this.locations + ", message=" + this.message + ", exception=" + this.exception + ")";
            }
        }
    }

    public static class ToolConfigurationNotification {
        private AssociatedRule associatedRule;
        private Message message;

        ToolConfigurationNotification(AssociatedRule associatedRule, Message message) {
            this.associatedRule = associatedRule;
            this.message = message;
        }

        public static ToolConfigurationNotificationBuilder builder() {
            return new ToolConfigurationNotificationBuilder();
        }

        public ToolConfigurationNotificationBuilder toBuilder() {
            return new ToolConfigurationNotificationBuilder().associatedRule(this.associatedRule).message(this.message);
        }

        public AssociatedRule getAssociatedRule() {
            return this.associatedRule;
        }

        public Message getMessage() {
            return this.message;
        }

        public ToolConfigurationNotification setAssociatedRule(AssociatedRule associatedRule) {
            this.associatedRule = associatedRule;
            return this;
        }

        public ToolConfigurationNotification setMessage(Message message) {
            this.message = message;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ToolConfigurationNotification)) {
                return false;
            }
            ToolConfigurationNotification other = (ToolConfigurationNotification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AssociatedRule this$associatedRule = this.getAssociatedRule();
            AssociatedRule other$associatedRule = other.getAssociatedRule();
            if (this$associatedRule == null ? other$associatedRule != null : !((Object)this$associatedRule).equals(other$associatedRule)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ToolConfigurationNotification;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AssociatedRule $associatedRule = this.getAssociatedRule();
            result = result * 59 + ($associatedRule == null ? 43 : ((Object)$associatedRule).hashCode());
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.ToolConfigurationNotification(associatedRule=" + this.getAssociatedRule() + ", message=" + this.getMessage() + ")";
        }

        public static class ToolConfigurationNotificationBuilder {
            private AssociatedRule associatedRule;
            private Message message;

            ToolConfigurationNotificationBuilder() {
            }

            public ToolConfigurationNotificationBuilder associatedRule(AssociatedRule associatedRule) {
                this.associatedRule = associatedRule;
                return this;
            }

            public ToolConfigurationNotificationBuilder message(Message message) {
                this.message = message;
                return this;
            }

            public ToolConfigurationNotification build() {
                return new ToolConfigurationNotification(this.associatedRule, this.message);
            }

            public String toString() {
                return "SarifLog.ToolConfigurationNotification.ToolConfigurationNotificationBuilder(associatedRule=" + this.associatedRule + ", message=" + this.message + ")";
            }
        }
    }

    public static class AssociatedRule {
        private String id;

        AssociatedRule(String id) {
            this.id = id;
        }

        public static AssociatedRuleBuilder builder() {
            return new AssociatedRuleBuilder();
        }

        public AssociatedRuleBuilder toBuilder() {
            return new AssociatedRuleBuilder().id(this.id);
        }

        public String getId() {
            return this.id;
        }

        public AssociatedRule setId(String id) {
            this.id = id;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssociatedRule)) {
                return false;
            }
            AssociatedRule other = (AssociatedRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AssociatedRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.AssociatedRule(id=" + this.getId() + ")";
        }

        public static class AssociatedRuleBuilder {
            private String id;

            AssociatedRuleBuilder() {
            }

            public AssociatedRuleBuilder id(String id) {
                this.id = id;
                return this;
            }

            public AssociatedRule build() {
                return new AssociatedRule(this.id);
            }

            public String toString() {
                return "SarifLog.AssociatedRule.AssociatedRuleBuilder(id=" + this.id + ")";
            }
        }
    }

    public static class Exception {
        private String message;

        Exception(String message) {
            this.message = message;
        }

        public static ExceptionBuilder builder() {
            return new ExceptionBuilder();
        }

        public ExceptionBuilder toBuilder() {
            return new ExceptionBuilder().message(this.message);
        }

        public String getMessage() {
            return this.message;
        }

        public Exception setMessage(String message) {
            this.message = message;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Exception)) {
                return false;
            }
            Exception other = (Exception)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Exception;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.Exception(message=" + this.getMessage() + ")";
        }

        public static class ExceptionBuilder {
            private String message;

            ExceptionBuilder() {
            }

            public ExceptionBuilder message(String message) {
                this.message = message;
                return this;
            }

            public Exception build() {
                return new Exception(this.message);
            }

            public String toString() {
                return "SarifLog.Exception.ExceptionBuilder(message=" + this.message + ")";
            }
        }
    }

    public static class MultiformatMessage {
        private String text;
        private String markdown;

        public MultiformatMessage(String text) {
            this.text = text;
        }

        public static MultiformatMessageBuilder builder() {
            return new MultiformatMessageBuilder();
        }

        public String getText() {
            return this.text;
        }

        public String getMarkdown() {
            return this.markdown;
        }

        public MultiformatMessage setText(String text) {
            this.text = text;
            return this;
        }

        public MultiformatMessage setMarkdown(String markdown) {
            this.markdown = markdown;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiformatMessage)) {
                return false;
            }
            MultiformatMessage other = (MultiformatMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            String this$markdown = this.getMarkdown();
            String other$markdown = other.getMarkdown();
            return !(this$markdown == null ? other$markdown != null : !this$markdown.equals(other$markdown));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MultiformatMessage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            String $markdown = this.getMarkdown();
            result = result * 59 + ($markdown == null ? 43 : $markdown.hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.MultiformatMessage(text=" + this.getText() + ", markdown=" + this.getMarkdown() + ")";
        }

        public MultiformatMessage() {
        }

        public MultiformatMessage(String text, String markdown) {
            this.text = text;
            this.markdown = markdown;
        }

        public static class MultiformatMessageBuilder {
            private String text;
            private String markdown;

            MultiformatMessageBuilder() {
            }

            public MultiformatMessageBuilder text(String text) {
                this.text = text;
                return this;
            }

            public MultiformatMessageBuilder markdown(String markdown) {
                this.markdown = markdown;
                return this;
            }

            public MultiformatMessage build() {
                return new MultiformatMessage(this.text, this.markdown);
            }

            public String toString() {
                return "SarifLog.MultiformatMessage.MultiformatMessageBuilder(text=" + this.text + ", markdown=" + this.markdown + ")";
            }
        }
    }

    public static class ReportingDescriptor {
        private String id;
        private String name;
        private MultiformatMessage shortDescription;
        private MultiformatMessage fullDescription;
        private MultiformatMessage messageStrings;
        private String helpUri;
        private MultiformatMessage help;
        private PropertyBag properties;

        ReportingDescriptor(String id, String name, MultiformatMessage shortDescription, MultiformatMessage fullDescription, MultiformatMessage messageStrings, String helpUri, MultiformatMessage help, PropertyBag properties) {
            this.id = id;
            this.name = name;
            this.shortDescription = shortDescription;
            this.fullDescription = fullDescription;
            this.messageStrings = messageStrings;
            this.helpUri = helpUri;
            this.help = help;
            this.properties = properties;
        }

        public static ReportingDescriptorBuilder builder() {
            return new ReportingDescriptorBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public MultiformatMessage getShortDescription() {
            return this.shortDescription;
        }

        public MultiformatMessage getFullDescription() {
            return this.fullDescription;
        }

        public MultiformatMessage getMessageStrings() {
            return this.messageStrings;
        }

        public String getHelpUri() {
            return this.helpUri;
        }

        public MultiformatMessage getHelp() {
            return this.help;
        }

        public PropertyBag getProperties() {
            return this.properties;
        }

        public ReportingDescriptor setId(String id) {
            this.id = id;
            return this;
        }

        public ReportingDescriptor setName(String name) {
            this.name = name;
            return this;
        }

        public ReportingDescriptor setShortDescription(MultiformatMessage shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public ReportingDescriptor setFullDescription(MultiformatMessage fullDescription) {
            this.fullDescription = fullDescription;
            return this;
        }

        public ReportingDescriptor setMessageStrings(MultiformatMessage messageStrings) {
            this.messageStrings = messageStrings;
            return this;
        }

        public ReportingDescriptor setHelpUri(String helpUri) {
            this.helpUri = helpUri;
            return this;
        }

        public ReportingDescriptor setHelp(MultiformatMessage help) {
            this.help = help;
            return this;
        }

        public ReportingDescriptor setProperties(PropertyBag properties) {
            this.properties = properties;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportingDescriptor)) {
                return false;
            }
            ReportingDescriptor other = (ReportingDescriptor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            MultiformatMessage this$shortDescription = this.getShortDescription();
            MultiformatMessage other$shortDescription = other.getShortDescription();
            if (this$shortDescription == null ? other$shortDescription != null : !((Object)this$shortDescription).equals(other$shortDescription)) {
                return false;
            }
            MultiformatMessage this$fullDescription = this.getFullDescription();
            MultiformatMessage other$fullDescription = other.getFullDescription();
            if (this$fullDescription == null ? other$fullDescription != null : !((Object)this$fullDescription).equals(other$fullDescription)) {
                return false;
            }
            MultiformatMessage this$messageStrings = this.getMessageStrings();
            MultiformatMessage other$messageStrings = other.getMessageStrings();
            if (this$messageStrings == null ? other$messageStrings != null : !((Object)this$messageStrings).equals(other$messageStrings)) {
                return false;
            }
            String this$helpUri = this.getHelpUri();
            String other$helpUri = other.getHelpUri();
            if (this$helpUri == null ? other$helpUri != null : !this$helpUri.equals(other$helpUri)) {
                return false;
            }
            MultiformatMessage this$help = this.getHelp();
            MultiformatMessage other$help = other.getHelp();
            if (this$help == null ? other$help != null : !((Object)this$help).equals(other$help)) {
                return false;
            }
            PropertyBag this$properties = this.getProperties();
            PropertyBag other$properties = other.getProperties();
            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReportingDescriptor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            MultiformatMessage $shortDescription = this.getShortDescription();
            result = result * 59 + ($shortDescription == null ? 43 : ((Object)$shortDescription).hashCode());
            MultiformatMessage $fullDescription = this.getFullDescription();
            result = result * 59 + ($fullDescription == null ? 43 : ((Object)$fullDescription).hashCode());
            MultiformatMessage $messageStrings = this.getMessageStrings();
            result = result * 59 + ($messageStrings == null ? 43 : ((Object)$messageStrings).hashCode());
            String $helpUri = this.getHelpUri();
            result = result * 59 + ($helpUri == null ? 43 : $helpUri.hashCode());
            MultiformatMessage $help = this.getHelp();
            result = result * 59 + ($help == null ? 43 : ((Object)$help).hashCode());
            PropertyBag $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.ReportingDescriptor(id=" + this.getId() + ", name=" + this.getName() + ", shortDescription=" + this.getShortDescription() + ", fullDescription=" + this.getFullDescription() + ", messageStrings=" + this.getMessageStrings() + ", helpUri=" + this.getHelpUri() + ", help=" + this.getHelp() + ", properties=" + this.getProperties() + ")";
        }

        public static class ReportingDescriptorBuilder {
            private String id;
            private String name;
            private MultiformatMessage shortDescription;
            private MultiformatMessage fullDescription;
            private MultiformatMessage messageStrings;
            private String helpUri;
            private MultiformatMessage help;
            private PropertyBag properties;

            ReportingDescriptorBuilder() {
            }

            public ReportingDescriptorBuilder id(String id) {
                this.id = id;
                return this;
            }

            public ReportingDescriptorBuilder name(String name) {
                this.name = name;
                return this;
            }

            public ReportingDescriptorBuilder shortDescription(MultiformatMessage shortDescription) {
                this.shortDescription = shortDescription;
                return this;
            }

            public ReportingDescriptorBuilder fullDescription(MultiformatMessage fullDescription) {
                this.fullDescription = fullDescription;
                return this;
            }

            public ReportingDescriptorBuilder messageStrings(MultiformatMessage messageStrings) {
                this.messageStrings = messageStrings;
                return this;
            }

            public ReportingDescriptorBuilder helpUri(String helpUri) {
                this.helpUri = helpUri;
                return this;
            }

            public ReportingDescriptorBuilder help(MultiformatMessage help) {
                this.help = help;
                return this;
            }

            public ReportingDescriptorBuilder properties(PropertyBag properties) {
                this.properties = properties;
                return this;
            }

            public ReportingDescriptor build() {
                return new ReportingDescriptor(this.id, this.name, this.shortDescription, this.fullDescription, this.messageStrings, this.helpUri, this.help, this.properties);
            }

            public String toString() {
                return "SarifLog.ReportingDescriptor.ReportingDescriptorBuilder(id=" + this.id + ", name=" + this.name + ", shortDescription=" + this.shortDescription + ", fullDescription=" + this.fullDescription + ", messageStrings=" + this.messageStrings + ", helpUri=" + this.helpUri + ", help=" + this.help + ", properties=" + this.properties + ")";
            }
        }
    }

    public static class Component {
        private String name;
        private String version;
        private String informationUri;
        private List<ReportingDescriptor> rules;

        Component(String name, String version, String informationUri, List<ReportingDescriptor> rules) {
            this.name = name;
            this.version = version;
            this.informationUri = informationUri;
            this.rules = rules;
        }

        public static ComponentBuilder builder() {
            return new ComponentBuilder();
        }

        public ComponentBuilder toBuilder() {
            return new ComponentBuilder().name(this.name).version(this.version).informationUri(this.informationUri).rules(this.rules);
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getInformationUri() {
            return this.informationUri;
        }

        public List<ReportingDescriptor> getRules() {
            return this.rules;
        }

        public Component setName(String name) {
            this.name = name;
            return this;
        }

        public Component setVersion(String version) {
            this.version = version;
            return this;
        }

        public Component setInformationUri(String informationUri) {
            this.informationUri = informationUri;
            return this;
        }

        public Component setRules(List<ReportingDescriptor> rules) {
            this.rules = rules;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Component)) {
                return false;
            }
            Component other = (Component)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$informationUri = this.getInformationUri();
            String other$informationUri = other.getInformationUri();
            if (this$informationUri == null ? other$informationUri != null : !this$informationUri.equals(other$informationUri)) {
                return false;
            }
            List<ReportingDescriptor> this$rules = this.getRules();
            List<ReportingDescriptor> other$rules = other.getRules();
            return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Component;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $informationUri = this.getInformationUri();
            result = result * 59 + ($informationUri == null ? 43 : $informationUri.hashCode());
            List<ReportingDescriptor> $rules = this.getRules();
            result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.Component(name=" + this.getName() + ", version=" + this.getVersion() + ", informationUri=" + this.getInformationUri() + ", rules=" + this.getRules() + ")";
        }

        public static class ComponentBuilder {
            private String name;
            private String version;
            private String informationUri;
            private List<ReportingDescriptor> rules;

            ComponentBuilder() {
            }

            public ComponentBuilder name(String name) {
                this.name = name;
                return this;
            }

            public ComponentBuilder version(String version) {
                this.version = version;
                return this;
            }

            public ComponentBuilder informationUri(String informationUri) {
                this.informationUri = informationUri;
                return this;
            }

            public ComponentBuilder rules(List<ReportingDescriptor> rules) {
                this.rules = rules;
                return this;
            }

            public Component build() {
                return new Component(this.name, this.version, this.informationUri, this.rules);
            }

            public String toString() {
                return "SarifLog.Component.ComponentBuilder(name=" + this.name + ", version=" + this.version + ", informationUri=" + this.informationUri + ", rules=" + this.rules + ")";
            }
        }
    }

    public static class Tool {
        private Component driver;

        Tool(Component driver) {
            this.driver = driver;
        }

        public static ToolBuilder builder() {
            return new ToolBuilder();
        }

        public Component getDriver() {
            return this.driver;
        }

        public Tool setDriver(Component driver) {
            this.driver = driver;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tool)) {
                return false;
            }
            Tool other = (Tool)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Component this$driver = this.getDriver();
            Component other$driver = other.getDriver();
            return !(this$driver == null ? other$driver != null : !((Object)this$driver).equals(other$driver));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Tool;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Component $driver = this.getDriver();
            result = result * 59 + ($driver == null ? 43 : ((Object)$driver).hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.Tool(driver=" + this.getDriver() + ")";
        }

        public static class ToolBuilder {
            private Component driver;

            ToolBuilder() {
            }

            public ToolBuilder driver(Component driver) {
                this.driver = driver;
                return this;
            }

            public Tool build() {
                return new Tool(this.driver);
            }

            public String toString() {
                return "SarifLog.Tool.ToolBuilder(driver=" + this.driver + ")";
            }
        }
    }

    public static class Run {
        private Tool tool;
        private List<Result> results;
        private List<Invocation> invocations;

        Run(Tool tool, List<Result> results, List<Invocation> invocations) {
            this.tool = tool;
            this.results = results;
            this.invocations = invocations;
        }

        public static RunBuilder builder() {
            return new RunBuilder();
        }

        public Tool getTool() {
            return this.tool;
        }

        public List<Result> getResults() {
            return this.results;
        }

        public List<Invocation> getInvocations() {
            return this.invocations;
        }

        public Run setTool(Tool tool) {
            this.tool = tool;
            return this;
        }

        public Run setResults(List<Result> results) {
            this.results = results;
            return this;
        }

        public Run setInvocations(List<Invocation> invocations) {
            this.invocations = invocations;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Run)) {
                return false;
            }
            Run other = (Run)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Tool this$tool = this.getTool();
            Tool other$tool = other.getTool();
            if (this$tool == null ? other$tool != null : !((Object)this$tool).equals(other$tool)) {
                return false;
            }
            List<Result> this$results = this.getResults();
            List<Result> other$results = other.getResults();
            if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
                return false;
            }
            List<Invocation> this$invocations = this.getInvocations();
            List<Invocation> other$invocations = other.getInvocations();
            return !(this$invocations == null ? other$invocations != null : !((Object)this$invocations).equals(other$invocations));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Run;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Tool $tool = this.getTool();
            result = result * 59 + ($tool == null ? 43 : ((Object)$tool).hashCode());
            List<Result> $results = this.getResults();
            result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
            List<Invocation> $invocations = this.getInvocations();
            result = result * 59 + ($invocations == null ? 43 : ((Object)$invocations).hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.Run(tool=" + this.getTool() + ", results=" + this.getResults() + ", invocations=" + this.getInvocations() + ")";
        }

        public static class RunBuilder {
            private Tool tool;
            private ArrayList<Result> results;
            private List<Invocation> invocations;

            RunBuilder() {
            }

            public RunBuilder tool(Tool tool) {
                this.tool = tool;
                return this;
            }

            public RunBuilder result(Result result) {
                if (this.results == null) {
                    this.results = new ArrayList();
                }
                this.results.add(result);
                return this;
            }

            public RunBuilder results(Collection<? extends Result> results) {
                if (results == null) {
                    throw new NullPointerException("results cannot be null");
                }
                if (this.results == null) {
                    this.results = new ArrayList();
                }
                this.results.addAll(results);
                return this;
            }

            public RunBuilder clearResults() {
                if (this.results != null) {
                    this.results.clear();
                }
                return this;
            }

            public RunBuilder invocations(List<Invocation> invocations) {
                this.invocations = invocations;
                return this;
            }

            public Run build() {
                List<Result> results;
                switch (this.results == null ? 0 : this.results.size()) {
                    case 0: {
                        results = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        results = Collections.singletonList(this.results.get(0));
                        break;
                    }
                    default: {
                        results = Collections.unmodifiableList(new ArrayList<Result>(this.results));
                    }
                }
                return new Run(this.tool, results, this.invocations);
            }

            public String toString() {
                return "SarifLog.Run.RunBuilder(tool=" + this.tool + ", results=" + this.results + ", invocations=" + this.invocations + ")";
            }
        }
    }

    public static class Message {
        private String text;
        private String markdown;
        private String id;

        Message(String text, String markdown, String id) {
            this.text = text;
            this.markdown = markdown;
            this.id = id;
        }

        public static MessageBuilder builder() {
            return new MessageBuilder();
        }

        public String getText() {
            return this.text;
        }

        public String getMarkdown() {
            return this.markdown;
        }

        public String getId() {
            return this.id;
        }

        public Message setText(String text) {
            this.text = text;
            return this;
        }

        public Message setMarkdown(String markdown) {
            this.markdown = markdown;
            return this;
        }

        public Message setId(String id) {
            this.id = id;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message other = (Message)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            String this$markdown = this.getMarkdown();
            String other$markdown = other.getMarkdown();
            if (this$markdown == null ? other$markdown != null : !this$markdown.equals(other$markdown)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Message;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            String $markdown = this.getMarkdown();
            result = result * 59 + ($markdown == null ? 43 : $markdown.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.Message(text=" + this.getText() + ", markdown=" + this.getMarkdown() + ", id=" + this.getId() + ")";
        }

        public static class MessageBuilder {
            private String text;
            private String markdown;
            private String id;

            MessageBuilder() {
            }

            public MessageBuilder text(String text) {
                this.text = text;
                return this;
            }

            public MessageBuilder markdown(String markdown) {
                this.markdown = markdown;
                return this;
            }

            public MessageBuilder id(String id) {
                this.id = id;
                return this;
            }

            public Message build() {
                return new Message(this.text, this.markdown, this.id);
            }

            public String toString() {
                return "SarifLog.Message.MessageBuilder(text=" + this.text + ", markdown=" + this.markdown + ", id=" + this.id + ")";
            }
        }
    }

    public static class Result {
        private String ruleId;
        private Integer ruleIndex;
        private Message message;
        private List<Location> locations;
        private PropertyBag properties;

        Result(String ruleId, Integer ruleIndex, Message message, List<Location> locations, PropertyBag properties) {
            this.ruleId = ruleId;
            this.ruleIndex = ruleIndex;
            this.message = message;
            this.locations = locations;
            this.properties = properties;
        }

        public static ResultBuilder builder() {
            return new ResultBuilder();
        }

        public String getRuleId() {
            return this.ruleId;
        }

        public Integer getRuleIndex() {
            return this.ruleIndex;
        }

        public Message getMessage() {
            return this.message;
        }

        public List<Location> getLocations() {
            return this.locations;
        }

        public PropertyBag getProperties() {
            return this.properties;
        }

        public Result setRuleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public Result setRuleIndex(Integer ruleIndex) {
            this.ruleIndex = ruleIndex;
            return this;
        }

        public Result setMessage(Message message) {
            this.message = message;
            return this;
        }

        public Result setLocations(List<Location> locations) {
            this.locations = locations;
            return this;
        }

        public Result setProperties(PropertyBag properties) {
            this.properties = properties;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$ruleId = this.getRuleId();
            String other$ruleId = other.getRuleId();
            if (this$ruleId == null ? other$ruleId != null : !this$ruleId.equals(other$ruleId)) {
                return false;
            }
            Integer this$ruleIndex = this.getRuleIndex();
            Integer other$ruleIndex = other.getRuleIndex();
            if (this$ruleIndex == null ? other$ruleIndex != null : !((Object)this$ruleIndex).equals(other$ruleIndex)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            List<Location> this$locations = this.getLocations();
            List<Location> other$locations = other.getLocations();
            if (this$locations == null ? other$locations != null : !((Object)this$locations).equals(other$locations)) {
                return false;
            }
            PropertyBag this$properties = this.getProperties();
            PropertyBag other$properties = other.getProperties();
            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $ruleId = this.getRuleId();
            result = result * 59 + ($ruleId == null ? 43 : $ruleId.hashCode());
            Integer $ruleIndex = this.getRuleIndex();
            result = result * 59 + ($ruleIndex == null ? 43 : ((Object)$ruleIndex).hashCode());
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            List<Location> $locations = this.getLocations();
            result = result * 59 + ($locations == null ? 43 : ((Object)$locations).hashCode());
            PropertyBag $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.Result(ruleId=" + this.getRuleId() + ", ruleIndex=" + this.getRuleIndex() + ", message=" + this.getMessage() + ", locations=" + this.getLocations() + ", properties=" + this.getProperties() + ")";
        }

        public static class ResultBuilder {
            private String ruleId;
            private Integer ruleIndex;
            private Message message;
            private List<Location> locations;
            private PropertyBag properties;

            ResultBuilder() {
            }

            public ResultBuilder ruleId(String ruleId) {
                this.ruleId = ruleId;
                return this;
            }

            public ResultBuilder ruleIndex(Integer ruleIndex) {
                this.ruleIndex = ruleIndex;
                return this;
            }

            public ResultBuilder message(Message message) {
                this.message = message;
                return this;
            }

            public ResultBuilder locations(List<Location> locations) {
                this.locations = locations;
                return this;
            }

            public ResultBuilder properties(PropertyBag properties) {
                this.properties = properties;
                return this;
            }

            public Result build() {
                return new Result(this.ruleId, this.ruleIndex, this.message, this.locations, this.properties);
            }

            public String toString() {
                return "SarifLog.Result.ResultBuilder(ruleId=" + this.ruleId + ", ruleIndex=" + this.ruleIndex + ", message=" + this.message + ", locations=" + this.locations + ", properties=" + this.properties + ")";
            }
        }
    }

    public static class Region {
        private Integer startLine;
        private Integer startColumn;
        private Integer endLine;
        private Integer endColumn;

        Region(Integer startLine, Integer startColumn, Integer endLine, Integer endColumn) {
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.endLine = endLine;
            this.endColumn = endColumn;
        }

        public static RegionBuilder builder() {
            return new RegionBuilder();
        }

        public Integer getStartLine() {
            return this.startLine;
        }

        public Integer getStartColumn() {
            return this.startColumn;
        }

        public Integer getEndLine() {
            return this.endLine;
        }

        public Integer getEndColumn() {
            return this.endColumn;
        }

        public Region setStartLine(Integer startLine) {
            this.startLine = startLine;
            return this;
        }

        public Region setStartColumn(Integer startColumn) {
            this.startColumn = startColumn;
            return this;
        }

        public Region setEndLine(Integer endLine) {
            this.endLine = endLine;
            return this;
        }

        public Region setEndColumn(Integer endColumn) {
            this.endColumn = endColumn;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Region)) {
                return false;
            }
            Region other = (Region)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$startLine = this.getStartLine();
            Integer other$startLine = other.getStartLine();
            if (this$startLine == null ? other$startLine != null : !((Object)this$startLine).equals(other$startLine)) {
                return false;
            }
            Integer this$startColumn = this.getStartColumn();
            Integer other$startColumn = other.getStartColumn();
            if (this$startColumn == null ? other$startColumn != null : !((Object)this$startColumn).equals(other$startColumn)) {
                return false;
            }
            Integer this$endLine = this.getEndLine();
            Integer other$endLine = other.getEndLine();
            if (this$endLine == null ? other$endLine != null : !((Object)this$endLine).equals(other$endLine)) {
                return false;
            }
            Integer this$endColumn = this.getEndColumn();
            Integer other$endColumn = other.getEndColumn();
            return !(this$endColumn == null ? other$endColumn != null : !((Object)this$endColumn).equals(other$endColumn));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Region;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $startLine = this.getStartLine();
            result = result * 59 + ($startLine == null ? 43 : ((Object)$startLine).hashCode());
            Integer $startColumn = this.getStartColumn();
            result = result * 59 + ($startColumn == null ? 43 : ((Object)$startColumn).hashCode());
            Integer $endLine = this.getEndLine();
            result = result * 59 + ($endLine == null ? 43 : ((Object)$endLine).hashCode());
            Integer $endColumn = this.getEndColumn();
            result = result * 59 + ($endColumn == null ? 43 : ((Object)$endColumn).hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.Region(startLine=" + this.getStartLine() + ", startColumn=" + this.getStartColumn() + ", endLine=" + this.getEndLine() + ", endColumn=" + this.getEndColumn() + ")";
        }

        public static class RegionBuilder {
            private Integer startLine;
            private Integer startColumn;
            private Integer endLine;
            private Integer endColumn;

            RegionBuilder() {
            }

            public RegionBuilder startLine(Integer startLine) {
                this.startLine = startLine;
                return this;
            }

            public RegionBuilder startColumn(Integer startColumn) {
                this.startColumn = startColumn;
                return this;
            }

            public RegionBuilder endLine(Integer endLine) {
                this.endLine = endLine;
                return this;
            }

            public RegionBuilder endColumn(Integer endColumn) {
                this.endColumn = endColumn;
                return this;
            }

            public Region build() {
                return new Region(this.startLine, this.startColumn, this.endLine, this.endColumn);
            }

            public String toString() {
                return "SarifLog.Region.RegionBuilder(startLine=" + this.startLine + ", startColumn=" + this.startColumn + ", endLine=" + this.endLine + ", endColumn=" + this.endColumn + ")";
            }
        }
    }

    public static class PropertyBag {
        private String ruleset;
        private Integer priority;
        private Set<String> tags;

        PropertyBag(String ruleset, Integer priority, Set<String> tags) {
            this.ruleset = ruleset;
            this.priority = priority;
            this.tags = tags;
        }

        public static PropertyBagBuilder builder() {
            return new PropertyBagBuilder();
        }

        public String getRuleset() {
            return this.ruleset;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public Set<String> getTags() {
            return this.tags;
        }

        public PropertyBag setRuleset(String ruleset) {
            this.ruleset = ruleset;
            return this;
        }

        public PropertyBag setPriority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public PropertyBag setTags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyBag)) {
                return false;
            }
            PropertyBag other = (PropertyBag)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$ruleset = this.getRuleset();
            String other$ruleset = other.getRuleset();
            if (this$ruleset == null ? other$ruleset != null : !this$ruleset.equals(other$ruleset)) {
                return false;
            }
            Integer this$priority = this.getPriority();
            Integer other$priority = other.getPriority();
            if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
                return false;
            }
            Set<String> this$tags = this.getTags();
            Set<String> other$tags = other.getTags();
            return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PropertyBag;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $ruleset = this.getRuleset();
            result = result * 59 + ($ruleset == null ? 43 : $ruleset.hashCode());
            Integer $priority = this.getPriority();
            result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
            Set<String> $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.PropertyBag(ruleset=" + this.getRuleset() + ", priority=" + this.getPriority() + ", tags=" + this.getTags() + ")";
        }

        public static class PropertyBagBuilder {
            private String ruleset;
            private Integer priority;
            private Set<String> tags;

            PropertyBagBuilder() {
            }

            public PropertyBagBuilder ruleset(String ruleset) {
                this.ruleset = ruleset;
                return this;
            }

            public PropertyBagBuilder priority(Integer priority) {
                this.priority = priority;
                return this;
            }

            public PropertyBagBuilder tags(Set<String> tags) {
                this.tags = tags;
                return this;
            }

            public PropertyBag build() {
                return new PropertyBag(this.ruleset, this.priority, this.tags);
            }

            public String toString() {
                return "SarifLog.PropertyBag.PropertyBagBuilder(ruleset=" + this.ruleset + ", priority=" + this.priority + ", tags=" + this.tags + ")";
            }
        }
    }

    public static class PhysicalLocation {
        private ArtifactLocation artifactLocation;
        private Region region;

        PhysicalLocation(ArtifactLocation artifactLocation, Region region) {
            this.artifactLocation = artifactLocation;
            this.region = region;
        }

        public static PhysicalLocationBuilder builder() {
            return new PhysicalLocationBuilder();
        }

        public ArtifactLocation getArtifactLocation() {
            return this.artifactLocation;
        }

        public Region getRegion() {
            return this.region;
        }

        public PhysicalLocation setArtifactLocation(ArtifactLocation artifactLocation) {
            this.artifactLocation = artifactLocation;
            return this;
        }

        public PhysicalLocation setRegion(Region region) {
            this.region = region;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PhysicalLocation)) {
                return false;
            }
            PhysicalLocation other = (PhysicalLocation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ArtifactLocation this$artifactLocation = this.getArtifactLocation();
            ArtifactLocation other$artifactLocation = other.getArtifactLocation();
            if (this$artifactLocation == null ? other$artifactLocation != null : !((Object)this$artifactLocation).equals(other$artifactLocation)) {
                return false;
            }
            Region this$region = this.getRegion();
            Region other$region = other.getRegion();
            return !(this$region == null ? other$region != null : !((Object)this$region).equals(other$region));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PhysicalLocation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ArtifactLocation $artifactLocation = this.getArtifactLocation();
            result = result * 59 + ($artifactLocation == null ? 43 : ((Object)$artifactLocation).hashCode());
            Region $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : ((Object)$region).hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.PhysicalLocation(artifactLocation=" + this.getArtifactLocation() + ", region=" + this.getRegion() + ")";
        }

        public static class PhysicalLocationBuilder {
            private ArtifactLocation artifactLocation;
            private Region region;

            PhysicalLocationBuilder() {
            }

            public PhysicalLocationBuilder artifactLocation(ArtifactLocation artifactLocation) {
                this.artifactLocation = artifactLocation;
                return this;
            }

            public PhysicalLocationBuilder region(Region region) {
                this.region = region;
                return this;
            }

            public PhysicalLocation build() {
                return new PhysicalLocation(this.artifactLocation, this.region);
            }

            public String toString() {
                return "SarifLog.PhysicalLocation.PhysicalLocationBuilder(artifactLocation=" + this.artifactLocation + ", region=" + this.region + ")";
            }
        }
    }

    public static class ArtifactLocation {
        private String uri;
        private String uriBaseId;
        private Integer index;

        ArtifactLocation(String uri, String uriBaseId, Integer index) {
            this.uri = uri;
            this.uriBaseId = uriBaseId;
            this.index = index;
        }

        public static ArtifactLocationBuilder builder() {
            return new ArtifactLocationBuilder();
        }

        public String getUri() {
            return this.uri;
        }

        public String getUriBaseId() {
            return this.uriBaseId;
        }

        public Integer getIndex() {
            return this.index;
        }

        public ArtifactLocation setUri(String uri) {
            this.uri = uri;
            return this;
        }

        public ArtifactLocation setUriBaseId(String uriBaseId) {
            this.uriBaseId = uriBaseId;
            return this;
        }

        public ArtifactLocation setIndex(Integer index) {
            this.index = index;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArtifactLocation)) {
                return false;
            }
            ArtifactLocation other = (ArtifactLocation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$uriBaseId = this.getUriBaseId();
            String other$uriBaseId = other.getUriBaseId();
            if (this$uriBaseId == null ? other$uriBaseId != null : !this$uriBaseId.equals(other$uriBaseId)) {
                return false;
            }
            Integer this$index = this.getIndex();
            Integer other$index = other.getIndex();
            return !(this$index == null ? other$index != null : !((Object)this$index).equals(other$index));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ArtifactLocation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $uriBaseId = this.getUriBaseId();
            result = result * 59 + ($uriBaseId == null ? 43 : $uriBaseId.hashCode());
            Integer $index = this.getIndex();
            result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.ArtifactLocation(uri=" + this.getUri() + ", uriBaseId=" + this.getUriBaseId() + ", index=" + this.getIndex() + ")";
        }

        public static class ArtifactLocationBuilder {
            private String uri;
            private String uriBaseId;
            private Integer index;

            ArtifactLocationBuilder() {
            }

            public ArtifactLocationBuilder uri(String uri) {
                this.uri = uri;
                return this;
            }

            public ArtifactLocationBuilder uriBaseId(String uriBaseId) {
                this.uriBaseId = uriBaseId;
                return this;
            }

            public ArtifactLocationBuilder index(Integer index) {
                this.index = index;
                return this;
            }

            public ArtifactLocation build() {
                return new ArtifactLocation(this.uri, this.uriBaseId, this.index);
            }

            public String toString() {
                return "SarifLog.ArtifactLocation.ArtifactLocationBuilder(uri=" + this.uri + ", uriBaseId=" + this.uriBaseId + ", index=" + this.index + ")";
            }
        }
    }

    public static class Location {
        private Integer id;
        private PhysicalLocation physicalLocation;

        Location(Integer id, PhysicalLocation physicalLocation) {
            this.id = id;
            this.physicalLocation = physicalLocation;
        }

        public static LocationBuilder builder() {
            return new LocationBuilder();
        }

        public Integer getId() {
            return this.id;
        }

        public PhysicalLocation getPhysicalLocation() {
            return this.physicalLocation;
        }

        public Location setId(Integer id) {
            this.id = id;
            return this;
        }

        public Location setPhysicalLocation(PhysicalLocation physicalLocation) {
            this.physicalLocation = physicalLocation;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Location)) {
                return false;
            }
            Location other = (Location)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$id = this.getId();
            Integer other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            PhysicalLocation this$physicalLocation = this.getPhysicalLocation();
            PhysicalLocation other$physicalLocation = other.getPhysicalLocation();
            return !(this$physicalLocation == null ? other$physicalLocation != null : !((Object)this$physicalLocation).equals(other$physicalLocation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Location;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            PhysicalLocation $physicalLocation = this.getPhysicalLocation();
            result = result * 59 + ($physicalLocation == null ? 43 : ((Object)$physicalLocation).hashCode());
            return result;
        }

        public String toString() {
            return "SarifLog.Location(id=" + this.getId() + ", physicalLocation=" + this.getPhysicalLocation() + ")";
        }

        public static class LocationBuilder {
            private Integer id;
            private PhysicalLocation physicalLocation;

            LocationBuilder() {
            }

            public LocationBuilder id(Integer id) {
                this.id = id;
                return this;
            }

            public LocationBuilder physicalLocation(PhysicalLocation physicalLocation) {
                this.physicalLocation = physicalLocation;
                return this;
            }

            public Location build() {
                return new Location(this.id, this.physicalLocation);
            }

            public String toString() {
                return "SarifLog.Location.LocationBuilder(id=" + this.id + ", physicalLocation=" + this.physicalLocation + ")";
            }
        }
    }
}

