/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.util.TypeMap;

@Deprecated
@InternalApi
public final class CollectionUtil {
    public static final TypeMap COLLECTION_INTERFACES_BY_NAMES = new TypeMap(List.class, Collection.class, Map.class, Set.class);
    public static final TypeMap COLLECTION_CLASSES_BY_NAMES = new TypeMap(ArrayList.class, LinkedList.class, Vector.class, HashMap.class, LinkedHashMap.class, TreeMap.class, TreeSet.class, HashSet.class, LinkedHashSet.class, Hashtable.class);

    private CollectionUtil() {
    }

    public static <T> int addWithoutDuplicates(Collection<T> source, Collection<T> target) {
        int added = 0;
        for (T item : source) {
            if (target.contains(item)) continue;
            target.add(item);
            ++added;
        }
        return added;
    }

    public static Class<?> getCollectionTypeFor(String shortName) {
        Class<?> cls = COLLECTION_CLASSES_BY_NAMES.typeFor(shortName);
        if (cls != null) {
            return cls;
        }
        return COLLECTION_INTERFACES_BY_NAMES.typeFor(shortName);
    }

    public static boolean isCollectionType(String typeName, boolean includeInterfaces) {
        if (COLLECTION_CLASSES_BY_NAMES.contains(typeName)) {
            return true;
        }
        return includeInterfaces && COLLECTION_INTERFACES_BY_NAMES.contains(typeName);
    }

    public static boolean isCollectionType(Class<?> clazzType, boolean includeInterfaces) {
        if (COLLECTION_CLASSES_BY_NAMES.contains(clazzType)) {
            return true;
        }
        return includeInterfaces && COLLECTION_INTERFACES_BY_NAMES.contains(clazzType);
    }

    public static <T> Set<T> asSet(T[] items) {
        return new HashSet<T>(Arrays.asList(items));
    }

    public static <K, V> Map<K, V> mapFrom(K[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new RuntimeException("mapFrom keys and values arrays have different sizes");
        }
        HashMap<K, V> map = new HashMap<K, V>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <K, V> Map<V, K> invertedMapFrom(Map<K, V> source) {
        HashMap<V, K> map = new HashMap<V, K>(source.size());
        for (Map.Entry<K, V> entry : source.entrySet()) {
            map.put(entry.getValue(), entry.getKey());
        }
        return map;
    }

    public static <T> List<T> toList(Iterator<T> it) {
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @SafeVarargs
    public static <T> List<T> listOf(T first, T ... rest) {
        ArrayList<T> result = new ArrayList<T>(rest.length + 1);
        result.add(first);
        Collections.addAll(result, rest);
        return result;
    }

    @Deprecated
    public static boolean arraysAreEqual(Object value, Object otherValue) {
        if (value instanceof Object[]) {
            if (otherValue instanceof Object[]) {
                return CollectionUtil.valuesAreTransitivelyEqual((Object[])value, (Object[])otherValue);
            }
            return false;
        }
        return false;
    }

    @Deprecated
    public static boolean valuesAreTransitivelyEqual(Object[] thisArray, Object[] thatArray) {
        if (thisArray == thatArray) {
            return true;
        }
        if (thisArray == null || thatArray == null) {
            return false;
        }
        if (thisArray.length != thatArray.length) {
            return false;
        }
        for (int i = 0; i < thisArray.length; ++i) {
            if (CollectionUtil.areEqual(thisArray[i], thatArray[i])) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean areEqual(Object value, Object otherValue) {
        if (value == otherValue) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (otherValue == null) {
            return false;
        }
        if (value.getClass().getComponentType() != null) {
            return CollectionUtil.arraysAreEqual(value, otherValue);
        }
        return value.equals(otherValue);
    }

    public static boolean isEmpty(Object[] items) {
        return items == null || items.length == 0;
    }

    public static boolean isNotEmpty(Object[] items) {
        return !CollectionUtil.isEmpty(items);
    }

    @Deprecated
    public static <T> boolean areSemanticEquals(T[] a, T[] b) {
        if (a == null) {
            return b == null || b.length == 0;
        }
        if (b == null) {
            return a.length == 0;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (CollectionUtil.areEqual(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static <T> T[] addWithoutDuplicates(T[] values, T newValue) {
        for (T value : values) {
            if (!value.equals(newValue)) continue;
            return values;
        }
        Object[] largerOne = (Object[])Array.newInstance(values.getClass().getComponentType(), values.length + 1);
        System.arraycopy(values, 0, largerOne, 0, values.length);
        largerOne[values.length] = newValue;
        return largerOne;
    }

    @Deprecated
    public static <T> T[] addWithoutDuplicates(T[] values, T[] newValues) {
        HashSet<T> originals = new HashSet<T>(values.length);
        for (T value : values) {
            originals.add(value);
        }
        ArrayList<T> newOnes = new ArrayList<T>(newValues.length);
        for (T value : newValues) {
            if (originals.contains(value)) continue;
            newOnes.add(value);
        }
        Object[] largerOne = (Object[])Array.newInstance(values.getClass().getComponentType(), values.length + newOnes.size());
        System.arraycopy(values, 0, largerOne, 0, values.length);
        for (int i = values.length; i < largerOne.length; ++i) {
            largerOne[i] = newOnes.get(i - values.length);
        }
        return largerOne;
    }
}

