/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.CompilationOutput;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Queues;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class InnerOutputIterable
implements Iterable<CompilationOutput> {
    private final Deque<CompilationOutput> toVisit = Queues.newArrayDeque();

    @VisibleForTesting
    InnerOutputIterable(CompilationOutput output) {
        if (output != null) {
            this.toVisit.push(output);
        }
    }

    @SfdcCalled
    public static InnerOutputIterable create(CodeUnit unit) {
        return new InnerOutputIterable(unit.getOutput());
    }

    @SfdcCalled
    public static InnerOutputIterable create(CompilationOutput output) {
        return new InnerOutputIterable(output);
    }

    @Override
    public Iterator<CompilationOutput> iterator() {
        return new Iterator<CompilationOutput>(){

            @Override
            public boolean hasNext() {
                return !InnerOutputIterable.this.toVisit.isEmpty();
            }

            @Override
            public CompilationOutput next() {
                if (InnerOutputIterable.this.toVisit.isEmpty()) {
                    throw new NoSuchElementException();
                }
                CompilationOutput output = (CompilationOutput)InnerOutputIterable.this.toVisit.remove();
                for (CompilationOutput innerOutput : output.getInnerOutputs().values()) {
                    InnerOutputIterable.this.toVisit.push(innerOutput);
                }
                return output;
            }
        };
    }
}

