/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.common.base.Initializer;
import apex.common.base.Initializers;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import com.google.common.base.Equivalence;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class StandardParentTable
implements ParentTable {
    public static final Initializer<ParentTable, TypeInfo> EMPTY = Initializers.ofInstance(StandardParentTable.emptyTable());
    private TypeInfo superType;
    private List<TypeInfo> immediateInterfaces = ImmutableList.of();
    private Set<Equivalence.Wrapper<TypeInfo>> allInterfaces = ImmutableSet.of();
    private boolean areSuperTypesResolved = false;
    private boolean areInterfacesResolved = false;

    private static ParentTable emptyTable() {
        StandardParentTable parentTable = new StandardParentTable();
        parentTable.superType = null;
        parentTable.areSuperTypesResolved = true;
        parentTable.areInterfacesResolved = true;
        return parentTable;
    }

    @Override
    public TypeInfo superType() {
        assert (this.areSuperTypesResolved) : "can't get super type as super types not resolved";
        return this.superType;
    }

    @Override
    public List<TypeInfo> immediateInterfaces() {
        assert (this.areInterfacesResolved) : "can't get immediate interfaces as interfaces not resolved";
        return this.immediateInterfaces;
    }

    @Override
    public Collection<TypeInfo> allInterfaces() {
        assert (this.areInterfacesResolved) : "can't get all interfaces as interfaces not resolved";
        return Collections2.transform(this.allInterfaces, Equivalence.Wrapper::get);
    }

    @Override
    public Set<Equivalence.Wrapper<TypeInfo>> allEquivalentInterfaces() {
        assert (this.areInterfacesResolved) : "can't get all interfaces as interfaces not resolved";
        return this.allInterfaces;
    }

    @Override
    public void resolveSuperTypes(TypeInfo superType) {
        assert (!this.areSuperTypesResolved) : "super type already resolved";
        assert (superType == null || superType.parents().areSuperTypesResolved()) : "superType's super types not resolved";
        this.superType = superType;
        this.areSuperTypesResolved = true;
    }

    @Override
    public void resolveInterfaces(List<TypeInfo> immediateInterfaces) {
        assert (this.areSuperTypesResolved) : "super type not resolved yet";
        assert (!this.areInterfacesResolved) : "interfaces are already resolved";
        this.immediateInterfaces = immediateInterfaces;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.superType != null) {
            builder.addAll(this.superType.parents().allEquivalentInterfaces());
        }
        for (TypeInfo interfaceType : immediateInterfaces) {
            assert (interfaceType.parents().areInterfacesResolved()) : "interfaceType's interfaces not resolved";
            Set<Equivalence.Wrapper<TypeInfo>> inheritedInterfaces = interfaceType.parents().allEquivalentInterfaces();
            builder.addAll(inheritedInterfaces);
            builder.add(interfaceType.getEquivalenceWrapper());
        }
        this.allInterfaces = builder.build();
        this.areInterfacesResolved = true;
    }

    @Override
    public boolean areSuperTypesResolved() {
        return this.areSuperTypesResolved;
    }

    @Override
    public boolean areInterfacesResolved() {
        return this.areInterfacesResolved;
    }

    @Override
    public boolean isResolved() {
        return this.areSuperTypesResolved && this.areInterfacesResolved;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("superType", this.superType).add("immediateInterfaces", this.immediateInterfaces).toString();
    }
}

