/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cache;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.cache.AnalysisCache;
import net.sourceforge.pmd.cache.AnalysisResult;
import net.sourceforge.pmd.cache.CachedRuleMapper;
import net.sourceforge.pmd.cache.internal.ClasspathFingerprinter;
import net.sourceforge.pmd.stat.Metric;
import org.apache.commons.io.FilenameUtils;

@Deprecated
@InternalApi
public abstract class AbstractAnalysisCache
implements AnalysisCache {
    protected static final Logger LOG = Logger.getLogger(AbstractAnalysisCache.class.getName());
    protected static final ClasspathFingerprinter FINGERPRINTER = new ClasspathFingerprinter();
    protected final String pmdVersion;
    protected final ConcurrentMap<String, AnalysisResult> fileResultsCache;
    protected final ConcurrentMap<String, AnalysisResult> updatedResultsCache;
    protected final CachedRuleMapper ruleMapper = new CachedRuleMapper();
    protected long rulesetChecksum;
    protected long auxClassPathChecksum;
    protected long executionClassPathChecksum;

    public AbstractAnalysisCache() {
        this.pmdVersion = PMDVersion.VERSION;
        this.fileResultsCache = new ConcurrentHashMap<String, AnalysisResult>();
        this.updatedResultsCache = new ConcurrentHashMap<String, AnalysisResult>();
    }

    @Override
    public boolean isUpToDate(File sourceFile) {
        try (TimedOperation to = TimeTracker.startOperation(TimedOperationCategory.ANALYSIS_CACHE, "up-to-date check");){
            boolean result;
            AnalysisResult updatedResult = new AnalysisResult(sourceFile);
            this.updatedResultsCache.put(sourceFile.getPath(), updatedResult);
            AnalysisResult analysisResult = (AnalysisResult)this.fileResultsCache.get(sourceFile.getPath());
            boolean bl = result = analysisResult != null && analysisResult.getFileChecksum() == updatedResult.getFileChecksum();
            if (LOG.isLoggable(Level.FINE)) {
                if (result) {
                    LOG.fine("Incremental Analysis cache HIT");
                } else {
                    LOG.fine("Incremental Analysis cache MISS - " + (analysisResult != null ? "file changed" : "no previous result found"));
                }
            }
            boolean bl2 = result;
            return bl2;
        }
    }

    @Override
    public List<RuleViolation> getCachedViolations(File sourceFile) {
        AnalysisResult analysisResult = (AnalysisResult)this.fileResultsCache.get(sourceFile.getPath());
        if (analysisResult == null) {
            return Collections.emptyList();
        }
        return analysisResult.getViolations();
    }

    @Override
    public void analysisFailed(File sourceFile) {
        this.updatedResultsCache.remove(sourceFile.getPath());
    }

    protected abstract boolean cacheExists();

    @Override
    public void checkValidity(RuleSets ruleSets, ClassLoader auxclassPathClassLoader) {
        try (TimedOperation to = TimeTracker.startOperation(TimedOperationCategory.ANALYSIS_CACHE, "validity check");){
            long currentAuxClassPathChecksum;
            boolean cacheIsValid = this.cacheExists();
            if (cacheIsValid && ruleSets.getChecksum() != this.rulesetChecksum) {
                LOG.info("Analysis cache invalidated, rulesets changed.");
                cacheIsValid = false;
            }
            if (auxclassPathClassLoader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)auxclassPathClassLoader;
                currentAuxClassPathChecksum = FINGERPRINTER.fingerprint(urlClassLoader.getURLs());
                if (cacheIsValid && currentAuxClassPathChecksum != this.auxClassPathChecksum) {
                    for (Rule r : ruleSets.getAllRules()) {
                        if (!r.isDfa() && !r.isTypeResolution()) continue;
                        LOG.info("Analysis cache invalidated, auxclasspath changed.");
                        cacheIsValid = false;
                        break;
                    }
                }
            } else {
                currentAuxClassPathChecksum = 0L;
            }
            long currentExecutionClassPathChecksum = FINGERPRINTER.fingerprint(this.getClassPathEntries());
            if (cacheIsValid && currentExecutionClassPathChecksum != this.executionClassPathChecksum) {
                LOG.info("Analysis cache invalidated, execution classpath changed.");
                cacheIsValid = false;
            }
            if (!cacheIsValid) {
                this.fileResultsCache.clear();
            }
            this.rulesetChecksum = ruleSets.getChecksum();
            this.auxClassPathChecksum = currentAuxClassPathChecksum;
            this.executionClassPathChecksum = currentExecutionClassPathChecksum;
            this.ruleMapper.initialize(ruleSets);
        }
    }

    private static boolean isClassPathWildcard(String entry) {
        return entry.endsWith("/*") || entry.endsWith("\\*");
    }

    private URL[] getClassPathEntries() {
        String classpath = System.getProperty("java.class.path");
        String[] classpathEntries = classpath.split(File.pathSeparator);
        final ArrayList<URL> entries = new ArrayList<URL>();
        final SimpleFileVisitor<Path> fileVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!attrs.isSymbolicLink()) {
                    entries.add(file.toUri().toURL());
                }
                return FileVisitResult.CONTINUE;
            }
        };
        SimpleFileVisitor<Path> jarFileVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String extension = FilenameUtils.getExtension((String)file.toString());
                if ("jar".equalsIgnoreCase(extension)) {
                    fileVisitor.visitFile(file, attrs);
                }
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            for (String entry : classpathEntries) {
                File f = new File(entry);
                if (AbstractAnalysisCache.isClassPathWildcard(entry)) {
                    Files.walkFileTree(new File(entry.substring(0, entry.length() - 1)).toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), 1, (FileVisitor<? super Path>)jarFileVisitor);
                    continue;
                }
                if (f.isFile()) {
                    entries.add(f.toURI().toURL());
                    continue;
                }
                if (!f.exists()) continue;
                Files.walkFileTree(f.toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)fileVisitor);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Incremental analysis can't check execution classpath contents", e);
            throw new RuntimeException(e);
        }
        return entries.toArray(new URL[0]);
    }

    @Override
    public void ruleViolationAdded(RuleViolation ruleViolation) {
        AnalysisResult analysisResult = (AnalysisResult)this.updatedResultsCache.get(ruleViolation.getFilename());
        analysisResult.addViolation(ruleViolation);
    }

    @Override
    public void metricAdded(Metric metric) {
    }
}

