/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class AnyTokenizer
implements Tokenizer {
    private static final Pattern DEFAULT_PATTERN = AnyTokenizer.makePattern("");
    private final Pattern pattern;
    private final String commentStart;

    private static Pattern makePattern(String singleLineCommentStart) {
        return Pattern.compile("\\w++" + AnyTokenizer.eolCommentFragment(singleLineCommentStart) + "|[^\"'\\s]|\"(?:[^\"\\\\]++|\\\\.)*+\"|'(?:[^'\\\\]++|\\\\.)*+'|\n");
    }

    public AnyTokenizer() {
        this(DEFAULT_PATTERN, "");
    }

    public AnyTokenizer(String eolCommentStart) {
        this(AnyTokenizer.makePattern(eolCommentStart), eolCommentStart);
    }

    private AnyTokenizer(Pattern pattern, String commentStart) {
        this.pattern = pattern;
        this.commentStart = commentStart;
    }

    private static String eolCommentFragment(String start) {
        if (StringUtils.isBlank((CharSequence)start)) {
            return "";
        }
        return "|(?:" + Pattern.quote(start) + "[^\n]*+)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        StringBuilder text = sourceCode.getCodeBuffer();
        Matcher matcher = this.pattern.matcher(text);
        int lineNo = 1;
        int lastLineStart = 0;
        try {
            while (matcher.find()) {
                String image = matcher.group();
                if (this.isComment(image)) continue;
                if (StringUtils.isWhitespace((CharSequence)image)) {
                    ++lineNo;
                    lastLineStart = matcher.end();
                    continue;
                }
                int bline = lineNo;
                int bcol = 1 + matcher.start() - lastLineStart;
                int ecol = StringUtil.columnNumberAt(image, image.length());
                if (ecol == image.length() + 1) {
                    ecol = bcol + image.length();
                } else {
                    lineNo += StringUtil.lineNumberAt(image, image.length()) - 1;
                    lastLineStart = matcher.start() + image.length() - ecol + 1;
                }
                tokenEntries.add(new TokenEntry(image, sourceCode.getFileName(), bline, bcol, --ecol));
            }
        }
        finally {
            tokenEntries.add(TokenEntry.getEOF());
        }
    }

    private boolean isComment(String tok) {
        return !this.commentStart.isEmpty() && tok.startsWith(this.commentStart);
    }
}

