/*
 * Decompiled with CFR 0.152.
 */
package apex.common.base;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;

public class Result<V> {
    private static final Result<?> NONE = new Result<Object>(null, null);
    private final V value;
    private final String error;

    Result(V value, String error) {
        this.value = value;
        this.error = error;
    }

    public static <V> Result<V> of(V value) {
        return new Result<V>(Objects.requireNonNull(value), null);
    }

    public static <V> Result<V> none() {
        return NONE;
    }

    public static <V> Result<V> error(String error) {
        return new Result<Object>(null, Objects.requireNonNull(Strings.emptyToNull(error)));
    }

    public boolean isPresent() {
        Preconditions.checkState(!this.hasError());
        return this.value != null;
    }

    public boolean absent() {
        Preconditions.checkState(!this.hasError());
        return this.value == null;
    }

    public boolean hasError() {
        return !Strings.isNullOrEmpty(this.error);
    }

    public boolean hasResult() {
        return this.value != null || !Strings.isNullOrEmpty(this.error);
    }

    public V get() {
        Preconditions.checkArgument(this.isPresent());
        return this.value;
    }

    public String getError() {
        Preconditions.checkArgument(this.hasError());
        return this.error;
    }

    public void throwIfError() {
        if (this.error != null) {
            throw new IllegalStateException(this.error);
        }
    }

    public String toString() {
        return this.hasError() ? "an error: " + String.valueOf(this.error) : "a value: " + String.valueOf(this.value);
    }
}

