/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.codeActions;

import apex.jorje.lsp.impl.codeActions.ExtractHandler;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.utils.CodeActionsUtil;
import apex.jorje.lsp.impl.utils.ExtractUtil;
import apex.jorje.lsp.impl.utils.Locations;
import apex.jorje.lsp.impl.visitors.CodeActionScope;
import apex.jorje.semantic.ast.expression.Expression;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.TextEdit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractLocalVariableHandler
implements ExtractHandler {
    private static final Logger logger = LoggerFactory.getLogger(ExtractLocalVariableHandler.class);
    private final Expression node;
    private final CodeActionScope scope;
    private static final String EXTRACT_VARIABLE_KEY = "extract.variable";
    private static final String LOCAL_VARIABLE_NAME = "v1";

    public ExtractLocalVariableHandler(Expression node, CodeActionScope scope) {
        this.node = node;
        this.scope = scope;
    }

    @Override
    public Optional<CodeAction> getCodeAction() {
        if (!ExtractUtil.canExtract(this.node).booleanValue()) {
            return Optional.empty();
        }
        try {
            ImmutableList<TextEdit> edits = ImmutableList.of(this.getNewStatementTextEdit(), this.getModifiedExpressionTextEdit());
            return CodeActionsUtil.buildCodeAction(EXTRACT_VARIABLE_KEY, "refactor.extract.variable", this.node, edits);
        }
        catch (BadLocationException e) {
            logger.error("Encountered a bad location while getting extract variable code action", (Throwable)e);
            return Optional.empty();
        }
    }

    private TextEdit getNewStatementTextEdit() {
        return CodeActionsUtil.buildTextEdit(this.scope.getNodeDeclarationLine() - 1, 0, 0, CodeActionsUtil.getNewStatementText(this.node, this.scope, LOCAL_VARIABLE_NAME));
    }

    private TextEdit getModifiedExpressionTextEdit() throws BadLocationException {
        return new TextEdit(Locations.Ranges.from(this.scope.getDocument(), this.scope.getNodeStartOffset(), this.scope.getNodeEndOffset(), this.node.getLoc().getLine(), this.scope.getNodeColumn()), LOCAL_VARIABLE_NAME);
    }
}

