/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.common.base.Result;
import apex.common.base.VoidResult;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.services.I18nSupport;
import org.objectweb.asm.ClassWriter;

class CompilationUtil {
    CompilationUtil() {
    }

    static byte[] getBytesOrAddTooLargeError(ClassWriter typeContextClassWriter, Compilation compilation, Errors errors) {
        byte[] bytes;
        try {
            bytes = typeContextClassWriter.toByteArray();
        }
        catch (RuntimeException x) {
            errors.markInvalid((AstNode)compilation, I18nSupport.getLabel("invalid.metadata.too.large"));
            bytes = new byte[]{};
        }
        return bytes;
    }

    static Result<Void> validateHasTopLevelModifiers(Compilation compilation) {
        ModifierGroup modifiers;
        if (TypeInfoUtil.isTopLevel(compilation.getDefiningType()) && !(modifiers = compilation.getDefiningType().getModifiers()).has(ModifierTypeInfos.GLOBAL) && !modifiers.has(ModifierTypeInfos.PUBLIC) && !modifiers.has(AnnotationTypeInfos.IS_TEST)) {
            return VoidResult.error(I18nSupport.getLabel("toplevel.must.be.public.or.global"));
        }
        return VoidResult.of();
    }
}

