/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler.parser;

import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.parser.impl.ApexLexer;
import apex.jorje.parser.impl.ApexParser;
import apex.jorje.parser.impl.CaseInsensitiveReaderStream;
import apex.jorje.parser.impl.HiddenTokenDecorator;
import apex.jorje.parser.impl.TokenSourceDecorator;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.parser.AnonymousParser;
import apex.jorje.semantic.compiler.parser.NamedParser;
import apex.jorje.semantic.compiler.parser.ParserOutput;
import apex.jorje.semantic.compiler.parser.ParserWorker;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.services.Version;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class ParserEngine {
    private static final ParserEngine ANONYMOUS = new ParserEngine(AnonymousParser.get());
    private static final ParserEngine NAMED = new ParserEngine(NamedParser.get());
    private static final LoadingCache<SourceVersion, ParserOutput> DATABASE_TREE_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.MINUTES).build(new CacheLoader<SourceVersion, ParserOutput>(){

        @Override
        public ParserOutput load(@Nonnull SourceVersion sourceVersion) {
            return NAMED.getParseTree(sourceVersion);
        }
    });
    private static final LoadingCache<SourceVersion, ParserOutput> FILE_BASED_TREE_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.MINUTES).build(new CacheLoader<SourceVersion, ParserOutput>(){

        @Override
        public ParserOutput load(@Nonnull SourceVersion sourceVersion) {
            return NAMED.getParseTree(sourceVersion);
        }
    });
    private final ParserWorker worker;

    private ParserEngine(ParserWorker worker) {
        this.worker = worker;
    }

    public static ParserEngine get(Type type) {
        switch (type) {
            case ANONYMOUS: {
                return ANONYMOUS;
            }
            case NAMED: {
                return NAMED;
            }
        }
        throw new UnexpectedCodePathException();
    }

    public ParserOutput parse(SourceFile source) {
        return this.parse(source, HiddenTokenBehavior.IGNORE);
    }

    public ParserOutput parse(SourceFile source, HiddenTokenBehavior hiddenTokenBehavior) {
        SourceVersion sourceVersion = new SourceVersion(source.getBody(), source.getVersion(), hiddenTokenBehavior);
        if (this == NAMED) {
            return source.isFileBased() ? FILE_BASED_TREE_CACHE.getUnchecked(sourceVersion) : DATABASE_TREE_CACHE.getUnchecked(sourceVersion);
        }
        return this.getParseTree(sourceVersion);
    }

    private ParserOutput getParseTree(SourceVersion sourceVersion) {
        CaseInsensitiveReaderStream stream = CaseInsensitiveReaderStream.create(sourceVersion.sourceBody);
        ApexLexer lexer = new ApexLexer((CharStream)stream);
        TokenSourceDecorator tokenSourceDecorator = sourceVersion.hiddenTokenBehavior == HiddenTokenBehavior.COLLECT_COMMENTS ? new HiddenTokenDecorator(lexer) : lexer;
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)tokenSourceDecorator);
        ApexParser parser = new ApexParser((TokenStream)tokenStream);
        parser.setVersion(sourceVersion.version);
        CompilationUnit unit = this.worker.parse(parser);
        return ParserOutput.createFromAntlr(parser, lexer, unit, tokenSourceDecorator.getHiddenTokenMap());
    }

    private static class SourceVersion {
        private final String sourceBody;
        private final Version version;
        private final HiddenTokenBehavior hiddenTokenBehavior;

        private SourceVersion(String sourceBody, Version version, HiddenTokenBehavior hiddenTokenBehavior) {
            this.sourceBody = sourceBody;
            this.version = version;
            this.hiddenTokenBehavior = hiddenTokenBehavior;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.sourceBody, this.version, this.hiddenTokenBehavior});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SourceVersion)) {
                return false;
            }
            SourceVersion sourceVersion = (SourceVersion)o;
            return Objects.equals(sourceVersion.sourceBody, this.sourceBody) && sourceVersion.version == this.version && sourceVersion.hiddenTokenBehavior == this.hiddenTokenBehavior;
        }
    }

    public static enum HiddenTokenBehavior {
        COLLECT_COMMENTS,
        IGNORE;

    }

    public static enum Type {
        ANONYMOUS,
        NAMED;

    }
}

