/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.semantic.symbol.type.WrapperTypeInfos;
import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreLists;
import java.util.List;
import java.util.Map;

public class GenericTypeInfoFactory {
    private GenericTypeInfoFactory() {
    }

    public static GenericTypeInfo createList(TypeInfo elementType) {
        return GenericTypeInfoFactory.create((TypeInfo)TypeInfos.LIST, ImmutableList.of(elementType));
    }

    public static GenericTypeInfo createList(SymbolResolver symbols, TypeInfo elementType) {
        return GenericTypeInfoFactory.create(symbols, (TypeInfo)TypeInfos.LIST, ImmutableList.of(elementType));
    }

    public static GenericTypeInfo createListIterator(TypeInfo elementType) {
        return GenericTypeInfoFactory.create((TypeInfo)WrapperTypeInfos.SYSTEM_LIST_ITERATOR, ImmutableList.of(elementType));
    }

    public static GenericTypeInfo createSet(TypeInfo elementType) {
        return GenericTypeInfoFactory.create((TypeInfo)TypeInfos.SET, ImmutableList.of(elementType));
    }

    public static GenericTypeInfo createSet(SymbolResolver symbols, TypeInfo elementType) {
        return GenericTypeInfoFactory.create(symbols, (TypeInfo)TypeInfos.SET, ImmutableList.of(elementType));
    }

    public static GenericTypeInfo createMap(TypeInfo keyType, TypeInfo valueType) {
        return GenericTypeInfoFactory.create((TypeInfo)TypeInfos.MAP, MoreLists.concatList(keyType, valueType));
    }

    public static GenericTypeInfo createMap(SymbolResolver symbols, TypeInfo keyType, TypeInfo valueType) {
        return GenericTypeInfoFactory.create(symbols, (TypeInfo)TypeInfos.MAP, MoreLists.concatList(keyType, valueType));
    }

    public static GenericTypeInfo create(TypeInfo type, TypeInfo ... argumentTypes) {
        return GenericTypeInfoFactory.create(type, MoreLists.asImmutableList(argumentTypes));
    }

    public static GenericTypeInfo create(TypeInfo unreifiedType, List<TypeInfo> argumentTypes) {
        assert (unreifiedType != null && argumentTypes != null) : "parameters cannot be null";
        assert (!argumentTypes.isEmpty()) : "argument types must be non empty";
        if (!unreifiedType.isResolved() || GenericTypeInfoFactory.isUnresolved(unreifiedType, argumentTypes)) {
            return UnresolvedTypeInfoFactory.create(unreifiedType, argumentTypes);
        }
        return GenericTypeInfo.builder().setUnreifiedType(unreifiedType).setTypeArguments(argumentTypes).build();
    }

    public static GenericTypeInfo create(SymbolResolver symbols, TypeInfo unreifiedType, List<TypeInfo> argumentTypes) {
        GenericTypeInfo type = GenericTypeInfoFactory.create(unreifiedType, argumentTypes);
        return GenericTypeInfoFactory.getCanonicalType(type, symbols.getCompilerService().getCanonicalGenerics());
    }

    private static GenericTypeInfo getCanonicalType(GenericTypeInfo type, Map<Equivalence.Wrapper<TypeInfo>, GenericTypeInfo> canonicalGenerics) {
        GenericTypeInfo canonicalType = canonicalGenerics.get(type.getEquivalenceWrapper());
        if (canonicalType != null) {
            return canonicalType;
        }
        canonicalGenerics.put(type.getEquivalenceWrapper(), type);
        return type;
    }

    public static GenericTypeInfo createQueryResultList(TypeInfo elementType) {
        if (GenericTypeInfoFactory.isUnresolved(TypeInfos.LIST, ImmutableList.of(elementType))) {
            return UnresolvedTypeInfoFactory.create((TypeInfo)TypeInfos.LIST, elementType);
        }
        return GenericTypeInfo.builder().setUnreifiedType(TypeInfos.LIST).setTypeArguments(elementType).setQueryResultList().build();
    }

    public static GenericTypeInfo createQueryResultList(SymbolResolver symbols, TypeInfo elementType) {
        GenericTypeInfo queryResultList = GenericTypeInfoFactory.createQueryResultList(elementType);
        return GenericTypeInfoFactory.getCanonicalType(queryResultList, symbols.getCompilerService().getCanonicalGenericsForQueryResultList());
    }

    private static boolean isUnresolved(TypeInfo unreifiedType, List<TypeInfo> argumentTypes) {
        BasicType basicType = unreifiedType.getBasicType();
        if ((basicType == BasicType.MAP || basicType == BasicType.SET) && TypeInfoEquivalence.isEquivalent(argumentTypes.get(0), TypeInfos.VOID)) {
            return true;
        }
        for (TypeInfo argumentType : argumentTypes) {
            if (argumentType.isResolved()) continue;
            return true;
        }
        return false;
    }
}

