/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoDepthCalculator;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class UnresolvedErrorCalculator {
    private static final TypeInfoVisitor.Default<List<String>> GET_ERRORS = new TypeInfoVisitor.Default<List<String>>(){

        @Override
        protected List<String> _default(TypeInfo type) {
            return ImmutableList.of(I18nSupport.getLabel("invalid.unresolved.type", type));
        }

        @Override
        public List<String> visit(GenericTypeInfo type) {
            TypeInfo unreifiedType = type.getUnreifiedType();
            if (unreifiedType == null) {
                return ImmutableList.of(TypeInfoUtil.containsPlaceholders(type.getTypeArguments()) ? I18nSupport.getLabel("invalid.unresolved.type", type.getApexName()) : I18nSupport.getLabel("type.arguments.for.non.parameterized.type", type.getRootUnreifiedType().getApexName()));
            }
            ArrayList<String> errors = new ArrayList<String>();
            if (!unreifiedType.isResolved()) {
                return UnresolvedErrorCalculator.getErrors(unreifiedType);
            }
            if (type.getTypeArguments().isEmpty()) {
                assert (!unreifiedType.getTypeArguments().isEmpty()) : "we created an unresolved type that was resolved";
                errors.add(I18nSupport.getLabel("no.type.arguments.for.parameterized.type", type));
                return errors;
            }
            int argumentCount = unreifiedType.getTypeArguments().size();
            if (argumentCount == 0) {
                errors.add(I18nSupport.getLabel("type.arguments.for.non.parameterized.type", type.getRootUnreifiedType().getApexName()));
            } else if (argumentCount != type.getTypeArguments().size()) {
                errors.add(I18nSupport.getLabel("invalid.parameterized.type.count", type.getRootUnreifiedType().getApexName(), argumentCount, type.getTypeArguments().size()));
            } else {
                int depth = GenericTypeInfoDepthCalculator.calculate(type);
                if (depth > GenericTypeInfo.MAX_SIZE) {
                    return ImmutableList.of(I18nSupport.getLabel("parameterized.type.too.deep", type, depth));
                }
                BasicType basicType = type.getBasicType();
                if ((basicType == BasicType.MAP || basicType == BasicType.SET) && TypeInfoEquivalence.isEquivalent(type.getTypeArguments().get(0), TypeInfos.VOID)) {
                    errors.add(I18nSupport.getLabel("invalid.parameterized.type", TypeInfos.VOID));
                }
                for (TypeInfo argumentType : type.getTypeArguments()) {
                    if (argumentType.isResolved()) continue;
                    errors.addAll(UnresolvedErrorCalculator.getErrors(argumentType));
                }
            }
            assert (!errors.isEmpty()) : "we are not resolved but there were no errors";
            return errors;
        }
    };

    public static List<String> getErrors(List<TypeInfo> types) {
        ArrayList<String> errors = new ArrayList<String>();
        for (TypeInfo type : types) {
            if (type.isResolved()) continue;
            errors.addAll(UnresolvedErrorCalculator.getErrors(type));
        }
        return errors;
    }

    public static List<String> getErrors(TypeInfo type) {
        assert (!type.isResolved()) : "asking for unresolved errors on a resolved type";
        return type.accept(GET_ERRORS);
    }
}

