/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ConcatenatedLists;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.PairList;
import com.google.common.collect.SingleAppendList;
import com.google.common.collect.SinglePrependList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class MoreLists {
    private static final Class<?> UNMODIFIABLE_RANDOM_ACCESS_LIST = Collections.unmodifiableList(Collections.emptyList()).getClass();
    private static final Class<?> UNMODIFIABLE_LIST = Collections.unmodifiableList(new LinkedList()).getClass();

    private MoreLists() {
    }

    @SafeVarargs
    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        LinkedList list = new LinkedList();
        Collections.addAll(list, elements);
        return list;
    }

    public static <T> List<T> concatList(T head, T tail) {
        Objects.requireNonNull(head, "head was not provided");
        Objects.requireNonNull(tail, "tail was not provided");
        return new PairList<T>(head, tail);
    }

    public static <T> List<T> prependList(T head, List<? extends T> tail) {
        Objects.requireNonNull(head, "head was not provided");
        Objects.requireNonNull(tail, "tail was not provided");
        if (tail.isEmpty()) {
            return ImmutableList.of(head);
        }
        return new SinglePrependList<T>(head, tail);
    }

    public static <T> List<T> appendList(List<? extends T> head, T tail) {
        Objects.requireNonNull(head, "head was not provided");
        Objects.requireNonNull(tail, "tail was not provided");
        if (head.isEmpty()) {
            return ImmutableList.of(tail);
        }
        return new SingleAppendList<T>(head, tail);
    }

    public static <T> List<T> concatLists(List<? extends T> head, List<? extends T> tail) {
        Objects.requireNonNull(head, "head was not provided");
        Objects.requireNonNull(tail, "tail was not provided");
        if (tail.isEmpty() && head.isEmpty()) {
            return ImmutableList.of();
        }
        if (tail.isEmpty()) {
            return head;
        }
        if (head.isEmpty()) {
            return tail;
        }
        return new ConcatenatedLists<T>(head, tail);
    }

    public static <T> ImmutableList<T> asImmutableList(Object[] array) {
        return ImmutableList.asImmutableList(array);
    }

    public static boolean isImmutableList(List<?> list) {
        return list != null && (list instanceof ImmutableList || list == Collections.emptyList() || list.getClass() == UNMODIFIABLE_RANDOM_ACCESS_LIST || list.getClass() == UNMODIFIABLE_LIST);
    }

    public static <T> List<T> toImmutableList(List<T> list) {
        if (MoreLists.isImmutableList(list)) {
            return list;
        }
        return MoreLists.isNullOrEmpty(list) ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    public static <T> List<T> toEmptyList(List<T> list) {
        return MoreLists.isNullOrEmpty(list) ? Collections.emptyList() : list;
    }

    public static <T> boolean isNullOrEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }

    public static <T> List<T> removeLast(List<T> list) {
        Preconditions.checkArgument(!MoreLists.isNullOrEmpty(list), "list must have size of at least 1 to remove the last element");
        if (list.size() == 1) {
            return Collections.emptyList();
        }
        return list.subList(0, list.size() - 1);
    }

    public static <T> Collector<T, ?, List<T>> toImmutableList() {
        return Collectors.collectingAndThen(Collectors.toList(), MoreLists::toImmutableList);
    }

    public static <T> Collector<T, ArrayList<T>, List<T>> toImmutableList(int initializedSize) {
        return Collector.of(() -> new ArrayList(initializedSize), ArrayList::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, MoreLists::toImmutableList, new Collector.Characteristics[0]);
    }
}

