/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class AvoidThrowingNullPointerExceptionRule
extends AbstractJavaRule {
    private final Set<String> npeInstances = new HashSet<String>();

    @Override
    public Object visit(ASTVariableInitializer varInitializer, Object data) {
        String initialedVarName = this.getInitializedVariableName(varInitializer);
        this.processAssignmentToVariable(varInitializer, initialedVarName);
        return super.visit(varInitializer, data);
    }

    private String getInitializedVariableName(ASTVariableInitializer initializer) {
        ASTVariableDeclaratorId varDeclaratorId = (ASTVariableDeclaratorId)((JavaNode)initializer.getParent()).getFirstDescendantOfType(ASTVariableDeclaratorId.class);
        return varDeclaratorId != null ? varDeclaratorId.getName() : null;
    }

    @Override
    public Object visit(ASTAssignmentOperator assignment, Object data) {
        String assignedVarName = this.getAssignedVariableName(assignment);
        this.processAssignmentToVariable(assignment, assignedVarName);
        return super.visit(assignment, data);
    }

    private String getAssignedVariableName(ASTAssignmentOperator assignment) {
        ASTName varName = (ASTName)((JavaNode)assignment.getParent()).getFirstDescendantOfType(ASTName.class);
        return varName != null ? varName.getImage() : null;
    }

    private void processAssignmentToVariable(JavaNode assignment, String varName) {
        Class<?> assignedValueType = this.getAssignedValueType(assignment);
        if (this.isNullPointerException(assignedValueType)) {
            this.npeInstances.add(varName);
        } else {
            this.npeInstances.remove(varName);
        }
    }

    private Class<?> getAssignedValueType(JavaNode assignment) {
        ASTClassOrInterfaceType assignedValueType = (ASTClassOrInterfaceType)assignment.getParent().getFirstDescendantOfType(ASTClassOrInterfaceType.class);
        return assignedValueType != null ? assignedValueType.getType() : null;
    }

    @Override
    public Object visit(ASTThrowStatement throwStatement, Object data) {
        if (this.throwsNullPointerException(throwStatement)) {
            this.addViolation(data, (Node)throwStatement);
        }
        return super.visit(throwStatement, data);
    }

    private boolean throwsNullPointerException(ASTThrowStatement throwStatement) {
        return this.throwsNullPointerExceptionType(throwStatement) || this.throwsNullPointerExceptionVariable(throwStatement);
    }

    private boolean throwsNullPointerExceptionType(ASTThrowStatement throwStatement) {
        ASTClassOrInterfaceType thrownType = (ASTClassOrInterfaceType)throwStatement.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
        if (thrownType != null) {
            Class<?> thrownException = thrownType.getType();
            return this.isNullPointerException(thrownException);
        }
        return false;
    }

    private boolean isNullPointerException(Class<?> clazz) {
        return NullPointerException.class.equals(clazz);
    }

    private boolean throwsNullPointerExceptionVariable(ASTThrowStatement throwStatement) {
        ASTName thrownVar = (ASTName)throwStatement.getFirstDescendantOfType(ASTName.class);
        if (thrownVar != null) {
            String thrownVarName = thrownVar.getImage();
            return this.npeInstances.contains(thrownVarName);
        }
        return false;
    }
}

