/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class CouplingBetweenObjectsRule
extends AbstractJavaRule {
    private int couplingCount;
    private Set<String> typesFoundSoFar;
    private static final PropertyDescriptor<Integer> THRESHOLD_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"threshold").desc("Unique type reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)20)).build();

    public CouplingBetweenObjectsRule() {
        this.definePropertyDescriptor(THRESHOLD_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit cu, Object data) {
        this.typesFoundSoFar = new HashSet<String>();
        this.couplingCount = 0;
        Object returnObj = cu.childrenAccept(this, data);
        if (this.couplingCount > (Integer)this.getProperty(THRESHOLD_DESCRIPTOR)) {
            this.addViolation(data, (Node)cu, "A value of " + this.couplingCount + " may denote a high amount of coupling within the class");
        }
        return returnObj;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTResultType node, Object data) {
        for (int x = 0; x < node.getNumChildren(); ++x) {
            Node classOrIntType;
            Node reftypeNode;
            Node tNode = node.getChild(x);
            if (!(tNode instanceof ASTType) || !((reftypeNode = tNode.getChild(0)) instanceof ASTReferenceType) || !((classOrIntType = reftypeNode.getChild(0)) instanceof ASTClassOrInterfaceType)) continue;
            Node nameNode = classOrIntType;
            this.checkVariableType(nameNode, nameNode.getImage());
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        this.handleASTTypeChildren(node);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFormalParameter node, Object data) {
        this.handleASTTypeChildren(node);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        for (int x = 0; x < node.getNumChildren(); ++x) {
            Node firstStmt = node.getChild(x);
            if (!(firstStmt instanceof ASTType)) continue;
            ASTType tp = (ASTType)firstStmt;
            Node nd = tp.getChild(0);
            this.checkVariableType(nd, nd.getImage());
        }
        return super.visit(node, data);
    }

    private void handleASTTypeChildren(Node node) {
        for (int x = 0; x < node.getNumChildren(); ++x) {
            Node sNode = node.getChild(x);
            if (!(sNode instanceof ASTType)) continue;
            Node nameNode = sNode.getChild(0);
            this.checkVariableType(nameNode, nameNode.getImage());
        }
    }

    private void checkVariableType(Node nameNode, String variableType) {
        if (nameNode.getParentsOfType(ASTClassOrInterfaceDeclaration.class).isEmpty()) {
            return;
        }
        ClassScope clzScope = (ClassScope)((JavaNode)nameNode).getScope().getEnclosingScope(ClassScope.class);
        if (!(clzScope.getClassName().equals(variableType) || this.filterTypes(variableType) || this.typesFoundSoFar.contains(variableType))) {
            ++this.couplingCount;
            this.typesFoundSoFar.add(variableType);
        }
    }

    private boolean filterTypes(String variableType) {
        return variableType != null && (variableType.startsWith("java.lang.") || "String".equals(variableType) || this.filterPrimitivesAndWrappers(variableType));
    }

    private boolean filterPrimitivesAndWrappers(String variableType) {
        return "int".equals(variableType) || "Integer".equals(variableType) || "char".equals(variableType) || "Character".equals(variableType) || "double".equals(variableType) || "long".equals(variableType) || "short".equals(variableType) || "float".equals(variableType) || "byte".equals(variableType) || "boolean".equals(variableType);
    }
}

