/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vf;

import apex.jorje.semantic.symbol.type.BasicType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public enum DataType {
    AutoNumber(false),
    Checkbox(false, BasicType.BOOLEAN),
    Currency(false, BasicType.CURRENCY),
    Date(false, BasicType.DATE),
    DateTime(false, BasicType.DATE_TIME),
    Email(false),
    EncryptedText(true),
    ExternalLookup(true),
    File(false),
    Hierarchy(false),
    Html(false),
    IndirectLookup(false),
    Location(false),
    LongTextArea(true),
    Lookup(false, BasicType.ID),
    MasterDetail(false),
    MetadataRelationship(false),
    MultiselectPicklist(true),
    Note(true),
    Number(false, BasicType.DECIMAL, BasicType.DOUBLE, BasicType.INTEGER, BasicType.LONG),
    Percent(false),
    Phone(false),
    Picklist(true),
    Summary(false),
    Text(true, BasicType.STRING),
    TextArea(true),
    Time(false, BasicType.TIME),
    Url(false),
    Unknown(true);

    private static final Logger LOGGER;
    public final boolean requiresEscaping;
    private final Set<BasicType> basicTypes;
    private static final Map<String, DataType> CASE_INSENSITIVE_MAP;
    private static final Map<BasicType, DataType> BASIC_TYPE_MAP;

    public static DataType fromString(String value) {
        DataType dataType = CASE_INSENSITIVE_MAP.get((value = value != null ? value : "").toLowerCase(Locale.ROOT));
        if (dataType == null) {
            dataType = Unknown;
            LOGGER.fine("Unable to determine DataType of " + value);
        }
        return dataType;
    }

    public static DataType fromBasicType(BasicType value) {
        DataType dataType;
        DataType dataType2 = dataType = value != null ? BASIC_TYPE_MAP.get(value) : null;
        if (dataType == null) {
            dataType = Unknown;
            LOGGER.fine("Unable to determine DataType of " + value);
        }
        return dataType;
    }

    private DataType(boolean requiresEscaping) {
        this(requiresEscaping, null);
    }

    private DataType(boolean requiresEscaping, BasicType ... basicTypes) {
        this.requiresEscaping = requiresEscaping;
        this.basicTypes = new HashSet<BasicType>();
        if (basicTypes != null) {
            this.basicTypes.addAll(Arrays.asList(basicTypes));
        }
    }

    static {
        LOGGER = Logger.getLogger(DataType.class.getName());
        CASE_INSENSITIVE_MAP = new HashMap<String, DataType>();
        BASIC_TYPE_MAP = new HashMap<BasicType, DataType>();
        for (DataType dataType : DataType.values()) {
            CASE_INSENSITIVE_MAP.put(dataType.name().toLowerCase(Locale.ROOT), dataType);
            for (BasicType basicType : dataType.basicTypes) {
                BASIC_TYPE_MAP.put(basicType, dataType);
            }
        }
    }
}

