/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.typings;

import apex.jorje.lsp.impl.typings.ModuleGenerator;
import apex.jorje.lsp.impl.typings.TypeDefinitionGenerator;
import apex.jorje.lsp.impl.typings.TypeDefinitionModule;
import apex.jorje.lsp.impl.typings.TypingOptions;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.testng.collections.Lists;

public class ApexModuleGenerator
implements ModuleGenerator {
    private static final String APEX_TYPE_DEFINITION_214_STG = "apex_typeDefinition_214.stg";
    private static final String APEX_TYPE_DEFINITION_216_STG = "apex_typeDefinition_216.stg";
    private static final String MODULE_RULE = "module";
    private static final String METHOD_PARAMS = "methodParams";
    private static final String CLASS_NAME = "className";
    private static final String METHOD_NAME = "methodName";
    private final CodeUnit codeUnit;

    ApexModuleGenerator(CodeUnit codeUnit) {
        this.codeUnit = codeUnit;
    }

    private static String getModule(Method node) {
        try {
            InputStream resource = TypingOptions.shouldUseScopedApex() ? TypeDefinitionGenerator.class.getClassLoader().getResourceAsStream(APEX_TYPE_DEFINITION_216_STG) : TypeDefinitionGenerator.class.getClassLoader().getResourceAsStream(APEX_TYPE_DEFINITION_214_STG);
            StringTemplateGroup templates = new StringTemplateGroup((Reader)new InputStreamReader(resource));
            StringTemplate module = templates.getInstanceOf(MODULE_RULE);
            module.setAttribute(CLASS_NAME, (Object)node.getDefiningType().getApexName());
            module.setAttribute(METHOD_NAME, (Object)node.getMethodInfo().getCanonicalName());
            for (Parameter parameter : node.getMethodInfo().getParameters()) {
                StringTemplate methodParams = templates.getInstanceOf(METHOD_PARAMS);
                methodParams.setAttribute("name", (Object)parameter.getName().getValue());
                module.setAttribute(METHOD_PARAMS, (Object)methodParams);
            }
            return module.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public Optional<TypeDefinitionModule> generateModulesIfApplicable() {
        AuraEnabledMethodsVisitor visitor = new AuraEnabledMethodsVisitor();
        this.codeUnit.additionalValidate(visitor);
        if (!visitor.getAuraEnabledMethods().isEmpty()) {
            return Optional.of(new TypeDefinitionModule(TypeDefinitionGenerator.generateTypeDefinitionFileName(this.codeUnit), visitor.getAuraEnabledMethods().stream().map(ApexModuleGenerator::getModule).reduce("", String::concat), TypeDefinitionModule.Kind.APEX));
        }
        return Optional.empty();
    }

    public static class AuraEnabledMethodsVisitor
    extends AstVisitor<AdditionalPassScope> {
        private final List<Method> auraEnabledMethods = Lists.newArrayList();

        @Override
        protected boolean defaultVisit() {
            return true;
        }

        @Override
        public void visitEnd(Method node, AdditionalPassScope scope) {
            TypeInfo definingType;
            super.visitEnd(node, scope);
            if (node != null && node.getModifiers() != null && node.getModifiers().all(AnnotationTypeInfos.AURA_ENABLED, ModifierTypeInfos.STATIC) && !node.getModifiers().isTest() && node.getMethodInfo() != null && (definingType = node.getMethodInfo().getDefiningType()) != null && definingType.getEnclosingType() == null) {
                this.auraEnabledMethods.add(node);
            }
        }

        List<Method> getAuraEnabledMethods() {
            return this.auraEnabledMethods;
        }
    }
}

