/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.utils;

import apex.jorje.data.ast.TypeRef;
import apex.jorje.lsp.impl.utils.ParentTableVisitor;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;

public class ParentTableUtil {
    public static void walkUserClassParentTable(UserClass node, ParentTableVisitor visitor) {
        TypeInfo parentInfo;
        TypeRef parent;
        if (!visitor.visit(node)) {
            return;
        }
        ParentTable superClassAndInterfaces = node.getDefiningType().parents();
        CodeUnitDetails details = node.getDefiningType().getCodeUnitDetails();
        Optional<TypeRef> optParent = details.getSuperTypeRef();
        if (optParent.isPresent() && !visitor.visit(parent = optParent.get(), parentInfo = superClassAndInterfaces.superType())) {
            return;
        }
        List<TypeRef> interfaces = details.getInterfaceTypeRefs();
        List<TypeInfo> implementedIntf = superClassAndInterfaces.immediateInterfaces();
        ListIterator<TypeRef> refIter = interfaces.listIterator();
        ListIterator<TypeInfo> infoIter = implementedIntf.listIterator();
        while (refIter.hasNext() && infoIter.hasNext()) {
            if (visitor.visit(refIter.next(), infoIter.next())) continue;
            return;
        }
    }

    public static void walkInterfaceParentTable(UserInterface node, ParentTableVisitor visitor) {
        if (!visitor.visit(node)) {
            return;
        }
        ParentTable superClassAndInterfaces = node.getDefiningType().parents();
        CodeUnitDetails details = node.getDefiningType().getCodeUnitDetails();
        List<TypeRef> interfaces = details.getInterfaceTypeRefs();
        List<TypeInfo> implementedIntf = superClassAndInterfaces.immediateInterfaces();
        ListIterator<TypeRef> refIter = interfaces.listIterator();
        ListIterator<TypeInfo> infoIter = implementedIntf.listIterator();
        while (refIter.hasNext() && infoIter.hasNext()) {
            if (visitor.visit(refIter.next(), infoIter.next())) continue;
            return;
        }
    }
}

